%------------------------------------------------------------------------------
% File     : ITP084^2 : TPTP v9.2.0. Released v7.5.0.
% Domain   : Interactive Theorem Proving
% Problem  : Sledgehammer KnowledgeKeysSecrets problem prob_119__3292052_1
% Version  : Especial.
% English  :

% Refs     : [BH+15] Blanchette et al. (2015), Mining the Archive of Formal
%          : [Des21] Desharnais (2021), Email to Geoff Sutcliffe
% Source   : [Des21]
% Names    : KnowledgeKeysSecrets/prob_119__3292052_1 [Des21]

% Status   : Theorem
% Rating   : 0.33 v8.1.0, 0.25 v7.5.0
% Syntax   : Number of formulae    :  344 ( 139 unt;  78 typ;   0 def)
%            Number of atoms       :  744 ( 433 equ;   0 cnn)
%            Maximal formula atoms :   13 (   2 avg)
%            Number of connectives : 4042 ( 141   ~;  45   |;  86   &;3444   @)
%                                         (   0 <=>; 326  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   23 (   7 avg)
%            Number of types       :    6 (   5 usr)
%            Number of type conns  :  284 ( 284   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   76 (  73 usr;   4 con; 0-5 aty)
%            Number of variables   : 1123 (  30   ^; 965   !;  72   ?;1123   :)
%                                         (  56  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments : This file was generated by Sledgehammer 2021-02-23 16:18:54.283
%------------------------------------------------------------------------------
% Could-be-implicit typings (7)
thf(ty_t_Secrecy__types_OExpression,type,
    secrecy_Expression: $tType ).

thf(ty_t_Secrecy__types_OSecrets,type,
    secrecy_Secrets: $tType ).

thf(ty_t_Secrecy__types_OspecID,type,
    secrecy_specID: $tType ).

thf(ty_t_Secrecy__types_OKeys,type,
    secrecy_Keys: $tType ).

thf(ty_t_Secrecy__types_OKS,type,
    secrecy_KS: $tType ).

thf(ty_t_List_Olist,type,
    list: $tType > $tType ).

thf(ty_t_Set_Oset,type,
    set: $tType > $tType ).

% Explicit typings (71)
thf(sy_cl_HOL_Otype,type,
    type: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

thf(sy_c_BNF__Greatest__Fixpoint_OShift,type,
    bNF_Greatest_Shift: 
      !>[A: $tType] : ( ( set @ ( list @ A ) ) > A > ( set @ ( list @ A ) ) ) ).

thf(sy_c_BNF__Greatest__Fixpoint_OSucc,type,
    bNF_Greatest_Succ: 
      !>[A: $tType] : ( ( set @ ( list @ A ) ) > ( list @ A ) > ( set @ A ) ) ).

thf(sy_c_BNF__Greatest__Fixpoint_Oshift,type,
    bNF_Greatest_shift: 
      !>[A: $tType,B: $tType] : ( ( ( list @ A ) > B ) > A > ( list @ A ) > B ) ).

thf(sy_c_CompLocalSecrets_OLocalSecrets,type,
    localSecrets: secrecy_specID > ( set @ secrecy_KS ) ).

thf(sy_c_Groups_Omonoid,type,
    monoid: 
      !>[A: $tType] : ( ( A > A > A ) > A > $o ) ).

thf(sy_c_If,type,
    if: 
      !>[A: $tType] : ( $o > A > A > A ) ).

thf(sy_c_KnowledgeKeysSecrets__Mirabelle__khazhniute_OeoutKnowCorrect,type,
    knowle1667810483orrect: secrecy_specID > secrecy_KS > $o ).

thf(sy_c_KnowledgeKeysSecrets__Mirabelle__khazhniute_OeoutKnowsECorrect,type,
    knowle1893229345orrect: secrecy_specID > secrecy_Expression > $o ).

thf(sy_c_KnowledgeKeysSecrets__Mirabelle__khazhniute_Oknow,type,
    knowle1437066798e_know: secrecy_specID > secrecy_KS > $o ).

thf(sy_c_KnowledgeKeysSecrets__Mirabelle__khazhniute_Oknows,type,
    knowle2055185861_knows: secrecy_specID > ( list @ secrecy_Expression ) > $o ).

thf(sy_c_ListExtras_Odisjoint,type,
    disjoint: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) > $o ) ).

thf(sy_c_ListExtras_Omem,type,
    mem: 
      !>[A: $tType] : ( A > ( list @ A ) > $o ) ).

thf(sy_c_ListExtras_OmemS,type,
    memS: 
      !>[A: $tType] : ( A > ( list @ A ) > $o ) ).

thf(sy_c_List_Oappend,type,
    append: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Oarg__min__list,type,
    arg_min_list: 
      !>[A: $tType,B: $tType] : ( ( A > B ) > ( list @ A ) > A ) ).

thf(sy_c_List_Obind,type,
    bind: 
      !>[A: $tType,B: $tType] : ( ( list @ A ) > ( A > ( list @ B ) ) > ( list @ B ) ) ).

thf(sy_c_List_Obutlast,type,
    butlast: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Oconcat,type,
    concat: 
      !>[A: $tType] : ( ( list @ ( list @ A ) ) > ( list @ A ) ) ).

thf(sy_c_List_Odistinct__adj,type,
    distinct_adj: 
      !>[A: $tType] : ( ( list @ A ) > $o ) ).

thf(sy_c_List_Ofoldr,type,
    foldr: 
      !>[A: $tType,B: $tType] : ( ( A > B > B ) > ( list @ A ) > B > B ) ).

thf(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( A > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Olast,type,
    last: 
      !>[A: $tType] : ( ( list @ A ) > A ) ).

thf(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( A > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : ( list @ A ) ).

thf(sy_c_List_Olist_Ocase__list,type,
    case_list: 
      !>[B: $tType,A: $tType] : ( B > ( A > ( list @ A ) > B ) > ( list @ A ) > B ) ).

thf(sy_c_List_Olist_Ohd,type,
    hd: 
      !>[A: $tType] : ( ( list @ A ) > A ) ).

thf(sy_c_List_Olist_Otl,type,
    tl: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Olist__ex1,type,
    list_ex1: 
      !>[A: $tType] : ( ( A > $o ) > ( list @ A ) > $o ) ).

thf(sy_c_List_Olistrelp,type,
    listrelp: 
      !>[A: $tType,B: $tType] : ( ( A > B > $o ) > ( list @ A ) > ( list @ B ) > $o ) ).

thf(sy_c_List_Omap__tailrec,type,
    map_tailrec: 
      !>[A: $tType,B: $tType] : ( ( A > B ) > ( list @ A ) > ( list @ B ) ) ).

thf(sy_c_List_Omap__tailrec__rev,type,
    map_tailrec_rev: 
      !>[A: $tType,B: $tType] : ( ( A > B ) > ( list @ A ) > ( list @ B ) > ( list @ B ) ) ).

thf(sy_c_List_Omaps,type,
    maps: 
      !>[A: $tType,B: $tType] : ( ( A > ( list @ B ) ) > ( list @ A ) > ( list @ B ) ) ).

thf(sy_c_List_Omember,type,
    member: 
      !>[A: $tType] : ( ( list @ A ) > A > $o ) ).

thf(sy_c_List_Oord_Olexordp__eq,type,
    lexordp_eq: 
      !>[A: $tType] : ( ( A > A > $o ) > ( list @ A ) > ( list @ A ) > $o ) ).

thf(sy_c_List_Oord__class_Olexordp,type,
    ord_lexordp: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) > $o ) ).

thf(sy_c_List_Oord__class_Olexordp__eq,type,
    ord_lexordp_eq: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) > $o ) ).

thf(sy_c_List_Oproduct__lists,type,
    product_lists: 
      !>[A: $tType] : ( ( list @ ( list @ A ) ) > ( list @ ( list @ A ) ) ) ).

thf(sy_c_List_Orev,type,
    rev: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Orotate1,type,
    rotate1: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Oshuffles,type,
    shuffles: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) > ( set @ ( list @ A ) ) ) ).

thf(sy_c_List_Osplice,type,
    splice: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Osubseqs,type,
    subseqs: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ ( list @ A ) ) ) ).

thf(sy_c_List_Osuccessively,type,
    successively: 
      !>[A: $tType] : ( ( A > A > $o ) > ( list @ A ) > $o ) ).

thf(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Secrecy_ODecr,type,
    decr: secrecy_Keys > ( list @ secrecy_Expression ) > ( list @ secrecy_Expression ) ).

thf(sy_c_Secrecy_OEnc,type,
    enc: secrecy_Keys > ( list @ secrecy_Expression ) > ( list @ secrecy_Expression ) ).

thf(sy_c_Secrecy_OEncrDecrKeys,type,
    encrDecrKeys: secrecy_Keys > secrecy_Keys > $o ).

thf(sy_c_Secrecy_OExt,type,
    ext: secrecy_Keys > ( list @ secrecy_Expression ) > ( list @ secrecy_Expression ) ).

thf(sy_c_Secrecy_OSign,type,
    sign: secrecy_Keys > ( list @ secrecy_Expression ) > ( list @ secrecy_Expression ) ).

thf(sy_c_Secrecy_Oeout,type,
    eout: secrecy_specID > secrecy_Expression > $o ).

thf(sy_c_Secrecy_Oine,type,
    ine: secrecy_specID > secrecy_Expression > $o ).

thf(sy_c_Secrecy_OnotSpecKeysSecretsExpr,type,
    notSpe1586871396tsExpr: secrecy_specID > ( list @ secrecy_Expression ) > $o ).

thf(sy_c_Secrecy_OspecKeys,type,
    specKeys: secrecy_specID > ( set @ secrecy_Keys ) ).

thf(sy_c_Secrecy_OspecKeysSecrets,type,
    specKeysSecrets: secrecy_specID > ( set @ secrecy_KS ) ).

thf(sy_c_Secrecy_OspecSecrets,type,
    specSecrets: secrecy_specID > ( set @ secrecy_Secrets ) ).

thf(sy_c_Secrecy__types_OExpression2KSL,type,
    secrec1371625429on2KSL: ( list @ secrecy_Expression ) > ( list @ secrecy_KS ) ).

thf(sy_c_Secrecy__types_OExpression_OkE,type,
    secrecy_kE: secrecy_Keys > secrecy_Expression ).

thf(sy_c_Secrecy__types_OExpression_OsE,type,
    secrecy_sE: secrecy_Secrets > secrecy_Expression ).

thf(sy_c_Secrecy__types_OKS2Expression,type,
    secrec1016742679ession: secrecy_KS > secrecy_Expression ).

thf(sy_c_Secrecy__types_OKS_Ocase__KS,type,
    secrecy_case_KS: 
      !>[A: $tType] : ( ( secrecy_Keys > A ) > ( secrecy_Secrets > A ) > secrecy_KS > A ) ).

thf(sy_c_Secrecy__types_OKS_OkKS,type,
    secrecy_kKS: secrecy_Keys > secrecy_KS ).

thf(sy_c_Secrecy__types_OKS_Orec__KS,type,
    secrecy_rec_KS: 
      !>[A: $tType] : ( ( secrecy_Keys > A ) > ( secrecy_Secrets > A ) > secrecy_KS > A ) ).

thf(sy_c_Secrecy__types_OKS_OsKS,type,
    secrecy_sKS: secrecy_Secrets > secrecy_KS ).

thf(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) ) ).

thf(sy_c_member,type,
    member2: 
      !>[A: $tType] : ( A > ( set @ A ) > $o ) ).

thf(sy_v_A,type,
    a: secrecy_specID ).

thf(sy_v_m,type,
    m: secrecy_Keys ).

% Relevant facts (255)
thf(fact_0_assms,axiom,
    knowle2055185861_knows @ a @ ( cons @ secrecy_Expression @ ( secrecy_kE @ m ) @ ( nil @ secrecy_Expression ) ) ).

% assms
thf(fact_1_KS_Oinject_I1_J,axiom,
    ! [X1: secrecy_Keys,Y1: secrecy_Keys] :
      ( ( ( secrecy_kKS @ X1 )
        = ( secrecy_kKS @ Y1 ) )
      = ( X1 = Y1 ) ) ).

% KS.inject(1)
thf(fact_2_knows4,axiom,
    ! [IncrDecrKeys: secrecy_Keys > secrecy_Keys > $o,K1: secrecy_Keys,K2: secrecy_Keys,A2: secrecy_specID,E: list @ secrecy_Expression] :
      ( ( ( IncrDecrKeys @ K1 @ K2 )
        & ( knowle1437066798e_know @ A2 @ ( secrecy_kKS @ K2 ) )
        & ( knowle2055185861_knows @ A2 @ ( enc @ K1 @ E ) ) )
     => ( knowle2055185861_knows @ A2 @ E ) ) ).

% knows4
thf(fact_3_knows5,axiom,
    ! [IncrDecrKeys: secrecy_Keys > secrecy_Keys > $o,K1: secrecy_Keys,K2: secrecy_Keys,A2: secrecy_specID,E: list @ secrecy_Expression] :
      ( ( ( IncrDecrKeys @ K1 @ K2 )
        & ( knowle1437066798e_know @ A2 @ ( secrecy_kKS @ K1 ) )
        & ( knowle2055185861_knows @ A2 @ ( sign @ K2 @ E ) ) )
     => ( knowle2055185861_knows @ A2 @ E ) ) ).

% knows5
thf(fact_4_knows6,axiom,
    ! [A2: secrecy_specID,K: secrecy_Keys,E1: list @ secrecy_Expression] :
      ( ( ( knowle1437066798e_know @ A2 @ ( secrecy_kKS @ K ) )
        & ( knowle2055185861_knows @ A2 @ E1 ) )
     => ( knowle2055185861_knows @ A2 @ ( enc @ K @ E1 ) ) ) ).

% knows6
thf(fact_5_knows7,axiom,
    ! [A2: secrecy_specID,K: secrecy_Keys,E1: list @ secrecy_Expression] :
      ( ( ( knowle1437066798e_know @ A2 @ ( secrecy_kKS @ K ) )
        & ( knowle2055185861_knows @ A2 @ E1 ) )
     => ( knowle2055185861_knows @ A2 @ ( sign @ K @ E1 ) ) ) ).

% knows7
thf(fact_6_know2knows__k,axiom,
    ! [A2: secrecy_specID,M: secrecy_Keys] :
      ( ( knowle1437066798e_know @ A2 @ ( secrecy_kKS @ M ) )
     => ( knowle2055185861_knows @ A2 @ ( cons @ secrecy_Expression @ ( secrecy_kE @ M ) @ ( nil @ secrecy_Expression ) ) ) ) ).

% know2knows_k
thf(fact_7_know1k,axiom,
    ! [C: secrecy_specID,M1: secrecy_Keys] :
      ( ( knowle2055185861_knows @ C @ ( cons @ secrecy_Expression @ ( secrec1016742679ession @ ( secrecy_kKS @ M1 ) ) @ ( nil @ secrecy_Expression ) ) )
      = ( knowle1437066798e_know @ C @ ( secrecy_kKS @ M1 ) ) ) ).

% know1k
thf(fact_8_KS_Osimps_I7_J,axiom,
    ! [A: $tType,F1: secrecy_Keys > A,F2: secrecy_Secrets > A,X1: secrecy_Keys] :
      ( ( secrecy_rec_KS @ A @ F1 @ F2 @ ( secrecy_kKS @ X1 ) )
      = ( F1 @ X1 ) ) ).

% KS.simps(7)
thf(fact_9_KS_Osimps_I5_J,axiom,
    ! [A: $tType,F1: secrecy_Keys > A,F2: secrecy_Secrets > A,X1: secrecy_Keys] :
      ( ( secrecy_case_KS @ A @ F1 @ F2 @ ( secrecy_kKS @ X1 ) )
      = ( F1 @ X1 ) ) ).

% KS.simps(5)
thf(fact_10_eoutKnowCorrect__L1k,axiom,
    ! [C: secrecy_specID,M: secrecy_Keys] :
      ( ( knowle1667810483orrect @ C @ ( secrecy_kKS @ M ) )
     => ( ( eout @ C @ ( secrecy_kE @ M ) )
       => ( ( member2 @ secrecy_Keys @ M @ ( specKeys @ C ) )
          | ( knowle1437066798e_know @ C @ ( secrecy_kKS @ M ) ) ) ) ) ).

% eoutKnowCorrect_L1k
thf(fact_11_eout__know__k,axiom,
    ! [C: secrecy_specID,M: secrecy_Keys] :
      ( ( knowle1667810483orrect @ C @ ( secrecy_kKS @ M ) )
      = ( ( eout @ C @ ( secrecy_kE @ M ) )
        = ( ( member2 @ secrecy_Keys @ M @ ( specKeys @ C ) )
          | ( knowle1437066798e_know @ C @ ( secrecy_kKS @ M ) ) ) ) ) ).

% eout_know_k
thf(fact_12_know_Osimps_I1_J,axiom,
    ! [A2: secrecy_specID,M: secrecy_Keys] :
      ( ( knowle1437066798e_know @ A2 @ ( secrecy_kKS @ M ) )
      = ( ( ine @ A2 @ ( secrecy_kE @ M ) )
        | ( member2 @ secrecy_KS @ ( secrecy_kKS @ M ) @ ( localSecrets @ A2 ) ) ) ) ).

% know.simps(1)
thf(fact_13_Expression_Oinject_I1_J,axiom,
    ! [X1: secrecy_Keys,Y1: secrecy_Keys] :
      ( ( ( secrecy_kE @ X1 )
        = ( secrecy_kE @ Y1 ) )
      = ( X1 = Y1 ) ) ).

% Expression.inject(1)
thf(fact_14_knows__emptyexpression,axiom,
    ! [C: secrecy_specID] : ( knowle2055185861_knows @ C @ ( nil @ secrecy_Expression ) ) ).

% knows_emptyexpression
thf(fact_15_KS2Expression_Osimps_I1_J,axiom,
    ! [M: secrecy_Keys] :
      ( ( secrec1016742679ession @ ( secrecy_kKS @ M ) )
      = ( secrecy_kE @ M ) ) ).

% KS2Expression.simps(1)
thf(fact_16_list_Oinject,axiom,
    ! [A: $tType,X21: A,X22: list @ A,Y21: A,Y22: list @ A] :
      ( ( ( cons @ A @ X21 @ X22 )
        = ( cons @ A @ Y21 @ Y22 ) )
      = ( ( X21 = Y21 )
        & ( X22 = Y22 ) ) ) ).

% list.inject
thf(fact_17_know1s,axiom,
    ! [C: secrecy_specID,M2: secrecy_Secrets] :
      ( ( knowle2055185861_knows @ C @ ( cons @ secrecy_Expression @ ( secrec1016742679ession @ ( secrecy_sKS @ M2 ) ) @ ( nil @ secrecy_Expression ) ) )
      = ( knowle1437066798e_know @ C @ ( secrecy_sKS @ M2 ) ) ) ).

% know1s
thf(fact_18_list_Odistinct_I1_J,axiom,
    ! [A: $tType,X21: A,X22: list @ A] :
      ( ( nil @ A )
     != ( cons @ A @ X21 @ X22 ) ) ).

% list.distinct(1)
thf(fact_19_list_OdiscI,axiom,
    ! [A: $tType,List: list @ A,X21: A,X22: list @ A] :
      ( ( List
        = ( cons @ A @ X21 @ X22 ) )
     => ( List
       != ( nil @ A ) ) ) ).

% list.discI
thf(fact_20_list_Oexhaust,axiom,
    ! [A: $tType,Y: list @ A] :
      ( ( Y
       != ( nil @ A ) )
     => ~ ! [X212: A,X222: list @ A] :
            ( Y
           != ( cons @ A @ X212 @ X222 ) ) ) ).

% list.exhaust
thf(fact_21_list_Oinducts,axiom,
    ! [A: $tType,P: ( list @ A ) > $o,List: list @ A] :
      ( ( P @ ( nil @ A ) )
     => ( ! [X12: A,X2: list @ A] :
            ( ( P @ X2 )
           => ( P @ ( cons @ A @ X12 @ X2 ) ) )
       => ( P @ List ) ) ) ).

% list.inducts
thf(fact_22_neq__Nil__conv,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( Xs
       != ( nil @ A ) )
      = ( ? [Y2: A,Ys: list @ A] :
            ( Xs
            = ( cons @ A @ Y2 @ Ys ) ) ) ) ).

% neq_Nil_conv
thf(fact_23_list__induct2_H,axiom,
    ! [A: $tType,B: $tType,P: ( list @ A ) > ( list @ B ) > $o,Xs: list @ A,Ys2: list @ B] :
      ( ( P @ ( nil @ A ) @ ( nil @ B ) )
     => ( ! [X: A,Xs2: list @ A] : ( P @ ( cons @ A @ X @ Xs2 ) @ ( nil @ B ) )
       => ( ! [Y3: B,Ys3: list @ B] : ( P @ ( nil @ A ) @ ( cons @ B @ Y3 @ Ys3 ) )
         => ( ! [X: A,Xs2: list @ A,Y3: B,Ys3: list @ B] :
                ( ( P @ Xs2 @ Ys3 )
               => ( P @ ( cons @ A @ X @ Xs2 ) @ ( cons @ B @ Y3 @ Ys3 ) ) )
           => ( P @ Xs @ Ys2 ) ) ) ) ) ).

% list_induct2'
thf(fact_24_splice_Oinduct,axiom,
    ! [A: $tType,P: ( list @ A ) > ( list @ A ) > $o,A0: list @ A,A1: list @ A] :
      ( ! [X_1: list @ A] : ( P @ ( nil @ A ) @ X_1 )
     => ( ! [X: A,Xs2: list @ A,Ys3: list @ A] :
            ( ( P @ Ys3 @ Xs2 )
           => ( P @ ( cons @ A @ X @ Xs2 ) @ Ys3 ) )
       => ( P @ A0 @ A1 ) ) ) ).

% splice.induct
thf(fact_25_induct__list012,axiom,
    ! [A: $tType,P: ( list @ A ) > $o,Xs: list @ A] :
      ( ( P @ ( nil @ A ) )
     => ( ! [X: A] : ( P @ ( cons @ A @ X @ ( nil @ A ) ) )
       => ( ! [X: A,Y3: A,Zs: list @ A] :
              ( ( P @ Zs )
             => ( ( P @ ( cons @ A @ Y3 @ Zs ) )
               => ( P @ ( cons @ A @ X @ ( cons @ A @ Y3 @ Zs ) ) ) ) )
         => ( P @ Xs ) ) ) ) ).

% induct_list012
thf(fact_26_min__list_Ocases,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [X3: list @ A] :
          ( ! [X: A,Xs2: list @ A] :
              ( X3
             != ( cons @ A @ X @ Xs2 ) )
         => ( X3
            = ( nil @ A ) ) ) ) ).

% min_list.cases
thf(fact_27_KS_Oinject_I2_J,axiom,
    ! [X23: secrecy_Secrets,Y23: secrecy_Secrets] :
      ( ( ( secrecy_sKS @ X23 )
        = ( secrecy_sKS @ Y23 ) )
      = ( X23 = Y23 ) ) ).

% KS.inject(2)
thf(fact_28_KS_Odistinct_I1_J,axiom,
    ! [X1: secrecy_Keys,X23: secrecy_Secrets] :
      ( ( secrecy_kKS @ X1 )
     != ( secrecy_sKS @ X23 ) ) ).

% KS.distinct(1)
thf(fact_29_KS_Oinduct,axiom,
    ! [P: secrecy_KS > $o,KS: secrecy_KS] :
      ( ! [X: secrecy_Keys] : ( P @ ( secrecy_kKS @ X ) )
     => ( ! [X: secrecy_Secrets] : ( P @ ( secrecy_sKS @ X ) )
       => ( P @ KS ) ) ) ).

% KS.induct
thf(fact_30_KS_Oexhaust,axiom,
    ! [Y: secrecy_KS] :
      ( ! [X12: secrecy_Keys] :
          ( Y
         != ( secrecy_kKS @ X12 ) )
     => ~ ! [X2: secrecy_Secrets] :
            ( Y
           != ( secrecy_sKS @ X2 ) ) ) ).

% KS.exhaust
thf(fact_31_KS_Osimps_I6_J,axiom,
    ! [A: $tType,F1: secrecy_Keys > A,F2: secrecy_Secrets > A,X23: secrecy_Secrets] :
      ( ( secrecy_case_KS @ A @ F1 @ F2 @ ( secrecy_sKS @ X23 ) )
      = ( F2 @ X23 ) ) ).

% KS.simps(6)
thf(fact_32_KS_Osimps_I8_J,axiom,
    ! [A: $tType,F1: secrecy_Keys > A,F2: secrecy_Secrets > A,X23: secrecy_Secrets] :
      ( ( secrecy_rec_KS @ A @ F1 @ F2 @ ( secrecy_sKS @ X23 ) )
      = ( F2 @ X23 ) ) ).

% KS.simps(8)
thf(fact_33_not__Cons__self2,axiom,
    ! [A: $tType,X3: A,Xs: list @ A] :
      ( ( cons @ A @ X3 @ Xs )
     != Xs ) ).

% not_Cons_self2
thf(fact_34_strict__sorted_Oinduct,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [P: ( list @ A ) > $o,A0: list @ A] :
          ( ( P @ ( nil @ A ) )
         => ( ! [X: A,Ys3: list @ A] :
                ( ( P @ Ys3 )
               => ( P @ ( cons @ A @ X @ Ys3 ) ) )
           => ( P @ A0 ) ) ) ) ).

% strict_sorted.induct
thf(fact_35_strict__sorted_Ocases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X3: list @ A] :
          ( ( X3
           != ( nil @ A ) )
         => ~ ! [X: A,Ys3: list @ A] :
                ( X3
               != ( cons @ A @ X @ Ys3 ) ) ) ) ).

% strict_sorted.cases
thf(fact_36_map__tailrec__rev_Oinduct,axiom,
    ! [A: $tType,B: $tType,P: ( A > B ) > ( list @ A ) > ( list @ B ) > $o,A0: A > B,A1: list @ A,A22: list @ B] :
      ( ! [F: A > B,X_1: list @ B] : ( P @ F @ ( nil @ A ) @ X_1 )
     => ( ! [F: A > B,A3: A,As: list @ A,Bs: list @ B] :
            ( ( P @ F @ As @ ( cons @ B @ ( F @ A3 ) @ Bs ) )
           => ( P @ F @ ( cons @ A @ A3 @ As ) @ Bs ) )
       => ( P @ A0 @ A1 @ A22 ) ) ) ).

% map_tailrec_rev.induct
thf(fact_37_list__nonempty__induct,axiom,
    ! [A: $tType,Xs: list @ A,P: ( list @ A ) > $o] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ! [X: A] : ( P @ ( cons @ A @ X @ ( nil @ A ) ) )
       => ( ! [X: A,Xs2: list @ A] :
              ( ( Xs2
               != ( nil @ A ) )
             => ( ( P @ Xs2 )
               => ( P @ ( cons @ A @ X @ Xs2 ) ) ) )
         => ( P @ Xs ) ) ) ) ).

% list_nonempty_induct
thf(fact_38_successively_Oinduct,axiom,
    ! [A: $tType,P: ( A > A > $o ) > ( list @ A ) > $o,A0: A > A > $o,A1: list @ A] :
      ( ! [P2: A > A > $o] : ( P @ P2 @ ( nil @ A ) )
     => ( ! [P2: A > A > $o,X: A] : ( P @ P2 @ ( cons @ A @ X @ ( nil @ A ) ) )
       => ( ! [P2: A > A > $o,X: A,Y3: A,Xs2: list @ A] :
              ( ( P @ P2 @ ( cons @ A @ Y3 @ Xs2 ) )
             => ( P @ P2 @ ( cons @ A @ X @ ( cons @ A @ Y3 @ Xs2 ) ) ) )
         => ( P @ A0 @ A1 ) ) ) ) ).

% successively.induct
thf(fact_39_arg__min__list_Oinduct,axiom,
    ! [B: $tType,A: $tType] :
      ( ( linorder @ B )
     => ! [P: ( A > B ) > ( list @ A ) > $o,A0: A > B,A1: list @ A] :
          ( ! [F: A > B,X: A] : ( P @ F @ ( cons @ A @ X @ ( nil @ A ) ) )
         => ( ! [F: A > B,X: A,Y3: A,Zs: list @ A] :
                ( ( P @ F @ ( cons @ A @ Y3 @ Zs ) )
               => ( P @ F @ ( cons @ A @ X @ ( cons @ A @ Y3 @ Zs ) ) ) )
           => ( ! [A3: A > B] : ( P @ A3 @ ( nil @ A ) )
             => ( P @ A0 @ A1 ) ) ) ) ) ).

% arg_min_list.induct
thf(fact_40_remdups__adj_Oinduct,axiom,
    ! [A: $tType,P: ( list @ A ) > $o,A0: list @ A] :
      ( ( P @ ( nil @ A ) )
     => ( ! [X: A] : ( P @ ( cons @ A @ X @ ( nil @ A ) ) )
       => ( ! [X: A,Y3: A,Xs2: list @ A] :
              ( ( ( X = Y3 )
               => ( P @ ( cons @ A @ X @ Xs2 ) ) )
             => ( ( ( X != Y3 )
                 => ( P @ ( cons @ A @ Y3 @ Xs2 ) ) )
               => ( P @ ( cons @ A @ X @ ( cons @ A @ Y3 @ Xs2 ) ) ) ) )
         => ( P @ A0 ) ) ) ) ).

% remdups_adj.induct
thf(fact_41_sorted__wrt_Oinduct,axiom,
    ! [A: $tType,P: ( A > A > $o ) > ( list @ A ) > $o,A0: A > A > $o,A1: list @ A] :
      ( ! [P2: A > A > $o] : ( P @ P2 @ ( nil @ A ) )
     => ( ! [P2: A > A > $o,X: A,Ys3: list @ A] :
            ( ( P @ P2 @ Ys3 )
           => ( P @ P2 @ ( cons @ A @ X @ Ys3 ) ) )
       => ( P @ A0 @ A1 ) ) ) ).

% sorted_wrt.induct
thf(fact_42_remdups__adj_Ocases,axiom,
    ! [A: $tType,X3: list @ A] :
      ( ( X3
       != ( nil @ A ) )
     => ( ! [X: A] :
            ( X3
           != ( cons @ A @ X @ ( nil @ A ) ) )
       => ~ ! [X: A,Y3: A,Xs2: list @ A] :
              ( X3
             != ( cons @ A @ X @ ( cons @ A @ Y3 @ Xs2 ) ) ) ) ) ).

% remdups_adj.cases
thf(fact_43_transpose_Ocases,axiom,
    ! [A: $tType,X3: list @ ( list @ A )] :
      ( ( X3
       != ( nil @ ( list @ A ) ) )
     => ( ! [Xss: list @ ( list @ A )] :
            ( X3
           != ( cons @ ( list @ A ) @ ( nil @ A ) @ Xss ) )
       => ~ ! [X: A,Xs2: list @ A,Xss: list @ ( list @ A )] :
              ( X3
             != ( cons @ ( list @ A ) @ ( cons @ A @ X @ Xs2 ) @ Xss ) ) ) ) ).

% transpose.cases
thf(fact_44_mem__Collect__eq,axiom,
    ! [A: $tType,A4: A,P: A > $o] :
      ( ( member2 @ A @ A4 @ ( collect @ A @ P ) )
      = ( P @ A4 ) ) ).

% mem_Collect_eq
thf(fact_45_Collect__mem__eq,axiom,
    ! [A: $tType,A2: set @ A] :
      ( ( collect @ A
        @ ^ [X4: A] : ( member2 @ A @ X4 @ A2 ) )
      = A2 ) ).

% Collect_mem_eq
thf(fact_46_Collect__cong,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X: A] :
          ( ( P @ X )
          = ( Q @ X ) )
     => ( ( collect @ A @ P )
        = ( collect @ A @ Q ) ) ) ).

% Collect_cong
thf(fact_47_ext,axiom,
    ! [B: $tType,A: $tType,F3: A > B,G: A > B] :
      ( ! [X: A] :
          ( ( F3 @ X )
          = ( G @ X ) )
     => ( F3 = G ) ) ).

% ext
thf(fact_48_shuffles_Oinduct,axiom,
    ! [A: $tType,P: ( list @ A ) > ( list @ A ) > $o,A0: list @ A,A1: list @ A] :
      ( ! [X_1: list @ A] : ( P @ ( nil @ A ) @ X_1 )
     => ( ! [Xs2: list @ A] : ( P @ Xs2 @ ( nil @ A ) )
       => ( ! [X: A,Xs2: list @ A,Y3: A,Ys3: list @ A] :
              ( ( P @ Xs2 @ ( cons @ A @ Y3 @ Ys3 ) )
             => ( ( P @ ( cons @ A @ X @ Xs2 ) @ Ys3 )
               => ( P @ ( cons @ A @ X @ Xs2 ) @ ( cons @ A @ Y3 @ Ys3 ) ) ) )
         => ( P @ A0 @ A1 ) ) ) ) ).

% shuffles.induct
thf(fact_49_min__list_Oinduct,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [P: ( list @ A ) > $o,A0: list @ A] :
          ( ! [X: A,Xs2: list @ A] :
              ( ! [X213: A,X223: list @ A] :
                  ( ( Xs2
                    = ( cons @ A @ X213 @ X223 ) )
                 => ( P @ Xs2 ) )
             => ( P @ ( cons @ A @ X @ Xs2 ) ) )
         => ( ( P @ ( nil @ A ) )
           => ( P @ A0 ) ) ) ) ).

% min_list.induct
thf(fact_50_know_Osimps_I2_J,axiom,
    ! [A2: secrecy_specID,M: secrecy_Secrets] :
      ( ( knowle1437066798e_know @ A2 @ ( secrecy_sKS @ M ) )
      = ( ( ine @ A2 @ ( secrecy_sE @ M ) )
        | ( member2 @ secrecy_KS @ ( secrecy_sKS @ M ) @ ( localSecrets @ A2 ) ) ) ) ).

% know.simps(2)
thf(fact_51_Expression2KSL_Osimps_I1_J,axiom,
    ( ( secrec1371625429on2KSL @ ( nil @ secrecy_Expression ) )
    = ( nil @ secrecy_KS ) ) ).

% Expression2KSL.simps(1)
thf(fact_52_insert__Nil,axiom,
    ! [A: $tType,X3: A] :
      ( ( insert @ A @ X3 @ ( nil @ A ) )
      = ( cons @ A @ X3 @ ( nil @ A ) ) ) ).

% insert_Nil
thf(fact_53_list__ex1__simps_I1_J,axiom,
    ! [A: $tType,P: A > $o] :
      ~ ( list_ex1 @ A @ P @ ( nil @ A ) ) ).

% list_ex1_simps(1)
thf(fact_54_eoutKnowsECorrect__def,axiom,
    ( knowle1893229345orrect
    = ( ^ [C2: secrecy_specID,E2: secrecy_Expression] :
          ( ( eout @ C2 @ E2 )
          = ( ? [K3: secrecy_Keys] :
                ( ( E2
                  = ( secrecy_kE @ K3 ) )
                & ( member2 @ secrecy_Keys @ K3 @ ( specKeys @ C2 ) ) )
            | ? [S: secrecy_Secrets] :
                ( ( E2
                  = ( secrecy_sE @ S ) )
                & ( member2 @ secrecy_Secrets @ S @ ( specSecrets @ C2 ) ) )
            | ( knowle2055185861_knows @ C2 @ ( cons @ secrecy_Expression @ E2 @ ( nil @ secrecy_Expression ) ) ) ) ) ) ) ).

% eoutKnowsECorrect_def
thf(fact_55_eoutKnowsECorrect__L1,axiom,
    ! [C: secrecy_specID,E: secrecy_Expression] :
      ( ( knowle1893229345orrect @ C @ E )
     => ( ( eout @ C @ E )
       => ( ? [K4: secrecy_Keys] :
              ( ( E
                = ( secrecy_kE @ K4 ) )
              & ( member2 @ secrecy_Keys @ K4 @ ( specKeys @ C ) ) )
          | ? [S2: secrecy_Secrets] :
              ( ( E
                = ( secrecy_sE @ S2 ) )
              & ( member2 @ secrecy_Secrets @ S2 @ ( specSecrets @ C ) ) )
          | ( knowle2055185861_knows @ C @ ( cons @ secrecy_Expression @ E @ ( nil @ secrecy_Expression ) ) ) ) ) ) ).

% eoutKnowsECorrect_L1
thf(fact_56_map__tailrec__rev_Oelims,axiom,
    ! [A: $tType,B: $tType,X3: A > B,Xa: list @ A,Xb: list @ B,Y: list @ B] :
      ( ( ( map_tailrec_rev @ A @ B @ X3 @ Xa @ Xb )
        = Y )
     => ( ( ( Xa
            = ( nil @ A ) )
         => ( Y != Xb ) )
       => ~ ! [A3: A,As: list @ A] :
              ( ( Xa
                = ( cons @ A @ A3 @ As ) )
             => ( Y
               != ( map_tailrec_rev @ A @ B @ X3 @ As @ ( cons @ B @ ( X3 @ A3 ) @ Xb ) ) ) ) ) ) ).

% map_tailrec_rev.elims
thf(fact_57_arg__min__list_Osimps_I1_J,axiom,
    ! [B: $tType,A: $tType] :
      ( ( linorder @ B )
     => ! [F3: A > B,X3: A] :
          ( ( arg_min_list @ A @ B @ F3 @ ( cons @ A @ X3 @ ( nil @ A ) ) )
          = X3 ) ) ).

% arg_min_list.simps(1)
thf(fact_58_notSpecKeysSecretsExpr__L1,axiom,
    ! [P: secrecy_specID,A4: secrecy_Expression,L: list @ secrecy_Expression] :
      ( ( notSpe1586871396tsExpr @ P @ ( cons @ secrecy_Expression @ A4 @ L ) )
     => ( notSpe1586871396tsExpr @ P @ ( cons @ secrecy_Expression @ A4 @ ( nil @ secrecy_Expression ) ) ) ) ).

% notSpecKeysSecretsExpr_L1
thf(fact_59_Expression_Oinject_I2_J,axiom,
    ! [X23: secrecy_Secrets,Y23: secrecy_Secrets] :
      ( ( ( secrecy_sE @ X23 )
        = ( secrecy_sE @ Y23 ) )
      = ( X23 = Y23 ) ) ).

% Expression.inject(2)
thf(fact_60_Expression_Odistinct_I1_J,axiom,
    ! [X1: secrecy_Keys,X23: secrecy_Secrets] :
      ( ( secrecy_kE @ X1 )
     != ( secrecy_sE @ X23 ) ) ).

% Expression.distinct(1)
thf(fact_61_notSpecKeysSecretsExpr__L2,axiom,
    ! [P: secrecy_specID,A4: secrecy_Expression,L: list @ secrecy_Expression] :
      ( ( notSpe1586871396tsExpr @ P @ ( cons @ secrecy_Expression @ A4 @ L ) )
     => ( notSpe1586871396tsExpr @ P @ L ) ) ).

% notSpecKeysSecretsExpr_L2
thf(fact_62_map__tailrec__rev_Osimps_I2_J,axiom,
    ! [A: $tType,B: $tType,F3: A > B,A4: A,As2: list @ A,Bs2: list @ B] :
      ( ( map_tailrec_rev @ A @ B @ F3 @ ( cons @ A @ A4 @ As2 ) @ Bs2 )
      = ( map_tailrec_rev @ A @ B @ F3 @ As2 @ ( cons @ B @ ( F3 @ A4 ) @ Bs2 ) ) ) ).

% map_tailrec_rev.simps(2)
thf(fact_63_map__tailrec__rev_Osimps_I1_J,axiom,
    ! [A: $tType,B: $tType,F3: A > B,Bs2: list @ B] :
      ( ( map_tailrec_rev @ A @ B @ F3 @ ( nil @ A ) @ Bs2 )
      = Bs2 ) ).

% map_tailrec_rev.simps(1)
thf(fact_64_KS2Expression_Osimps_I2_J,axiom,
    ! [M: secrecy_Secrets] :
      ( ( secrec1016742679ession @ ( secrecy_sKS @ M ) )
      = ( secrecy_sE @ M ) ) ).

% KS2Expression.simps(2)
thf(fact_65_eoutKnowCorrect__L1s,axiom,
    ! [C: secrecy_specID,M: secrecy_Secrets] :
      ( ( knowle1667810483orrect @ C @ ( secrecy_sKS @ M ) )
     => ( ( eout @ C @ ( secrecy_sE @ M ) )
       => ( ( member2 @ secrecy_Secrets @ M @ ( specSecrets @ C ) )
          | ( knowle1437066798e_know @ C @ ( secrecy_sKS @ M ) ) ) ) ) ).

% eoutKnowCorrect_L1s
thf(fact_66_eout__know__s,axiom,
    ! [C: secrecy_specID,M: secrecy_Secrets] :
      ( ( knowle1667810483orrect @ C @ ( secrecy_sKS @ M ) )
      = ( ( eout @ C @ ( secrecy_sE @ M ) )
        = ( ( member2 @ secrecy_Secrets @ M @ ( specSecrets @ C ) )
          | ( knowle1437066798e_know @ C @ ( secrecy_sKS @ M ) ) ) ) ) ).

% eout_know_s
thf(fact_67_product__lists_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( product_lists @ A @ ( nil @ ( list @ A ) ) )
      = ( cons @ ( list @ A ) @ ( nil @ A ) @ ( nil @ ( list @ A ) ) ) ) ).

% product_lists.simps(1)
thf(fact_68_subseqs_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( subseqs @ A @ ( nil @ A ) )
      = ( cons @ ( list @ A ) @ ( nil @ A ) @ ( nil @ ( list @ A ) ) ) ) ).

% subseqs.simps(1)
thf(fact_69_DecrEnc,axiom,
    ! [K12: secrecy_Keys,K22: secrecy_Keys,E3: list @ secrecy_Expression] :
      ( ( encrDecrKeys @ K12 @ K22 )
     => ( ( decr @ K22 @ ( enc @ K12 @ E3 ) )
        = E3 ) ) ).

% DecrEnc
thf(fact_70_ExtSign,axiom,
    ! [K12: secrecy_Keys,K22: secrecy_Keys,E3: list @ secrecy_Expression] :
      ( ( encrDecrKeys @ K12 @ K22 )
     => ( ( ext @ K12 @ ( sign @ K22 @ E3 ) )
        = E3 ) ) ).

% ExtSign
thf(fact_71_notSpecKeysSecretsExpr__def,axiom,
    ( notSpe1586871396tsExpr
    = ( ^ [P3: secrecy_specID,E2: list @ secrecy_Expression] :
          ( ! [X4: secrecy_Keys] :
              ( ( mem @ secrecy_Expression @ ( secrecy_kE @ X4 ) @ E2 )
             => ~ ( member2 @ secrecy_KS @ ( secrecy_kKS @ X4 ) @ ( specKeysSecrets @ P3 ) ) )
          & ! [Y2: secrecy_Secrets] :
              ( ( mem @ secrecy_Expression @ ( secrecy_sE @ Y2 ) @ E2 )
             => ~ ( member2 @ secrecy_KS @ ( secrecy_sKS @ Y2 ) @ ( specKeysSecrets @ P3 ) ) ) ) ) ) ).

% notSpecKeysSecretsExpr_def
thf(fact_72_ord_Olexordp__eq__simps_I3_J,axiom,
    ! [A: $tType,Less: A > A > $o,X3: A,Xs: list @ A] :
      ~ ( lexordp_eq @ A @ Less @ ( cons @ A @ X3 @ Xs ) @ ( nil @ A ) ) ).

% ord.lexordp_eq_simps(3)
thf(fact_73_bind__simps_I1_J,axiom,
    ! [B: $tType,A: $tType,F3: B > ( list @ A )] :
      ( ( bind @ B @ A @ ( nil @ B ) @ F3 )
      = ( nil @ A ) ) ).

% bind_simps(1)
thf(fact_74_ord_Olexordp__eq__simps_I4_J,axiom,
    ! [A: $tType,Less: A > A > $o,X3: A,Xs: list @ A,Y: A,Ys2: list @ A] :
      ( ( lexordp_eq @ A @ Less @ ( cons @ A @ X3 @ Xs ) @ ( cons @ A @ Y @ Ys2 ) )
      = ( ( Less @ X3 @ Y )
        | ( ~ ( Less @ Y @ X3 )
          & ( lexordp_eq @ A @ Less @ Xs @ Ys2 ) ) ) ) ).

% ord.lexordp_eq_simps(4)
thf(fact_75_ord_Olexordp__eq__simps_I1_J,axiom,
    ! [A: $tType,Less: A > A > $o,Ys2: list @ A] : ( lexordp_eq @ A @ Less @ ( nil @ A ) @ Ys2 ) ).

% ord.lexordp_eq_simps(1)
thf(fact_76_ord_Olexordp__eq__simps_I2_J,axiom,
    ! [A: $tType,Less: A > A > $o,Xs: list @ A] :
      ( ( lexordp_eq @ A @ Less @ Xs @ ( nil @ A ) )
      = ( Xs
        = ( nil @ A ) ) ) ).

% ord.lexordp_eq_simps(2)
thf(fact_77_ord_Olexordp__eq_Ocong,axiom,
    ! [A: $tType] :
      ( ( lexordp_eq @ A )
      = ( lexordp_eq @ A ) ) ).

% ord.lexordp_eq.cong
thf(fact_78_ord_Olexordp__eq__refl,axiom,
    ! [A: $tType,Less: A > A > $o,Xs: list @ A] : ( lexordp_eq @ A @ Less @ Xs @ Xs ) ).

% ord.lexordp_eq_refl
thf(fact_79_ord_Olexordp__eq_OCons__eq,axiom,
    ! [A: $tType,Less: A > A > $o,X3: A,Y: A,Xs: list @ A,Ys2: list @ A] :
      ( ~ ( Less @ X3 @ Y )
     => ( ~ ( Less @ Y @ X3 )
       => ( ( lexordp_eq @ A @ Less @ Xs @ Ys2 )
         => ( lexordp_eq @ A @ Less @ ( cons @ A @ X3 @ Xs ) @ ( cons @ A @ Y @ Ys2 ) ) ) ) ) ).

% ord.lexordp_eq.Cons_eq
thf(fact_80_ord_Olexordp__eq_OCons,axiom,
    ! [A: $tType,Less: A > A > $o,X3: A,Y: A,Xs: list @ A,Ys2: list @ A] :
      ( ( Less @ X3 @ Y )
     => ( lexordp_eq @ A @ Less @ ( cons @ A @ X3 @ Xs ) @ ( cons @ A @ Y @ Ys2 ) ) ) ).

% ord.lexordp_eq.Cons
thf(fact_81_ord_Olexordp__eq_ONil,axiom,
    ! [A: $tType,Less: A > A > $o,Ys2: list @ A] : ( lexordp_eq @ A @ Less @ ( nil @ A ) @ Ys2 ) ).

% ord.lexordp_eq.Nil
thf(fact_82_ord_Olexordp__eq_Oinducts,axiom,
    ! [A: $tType,Less: A > A > $o,X1: list @ A,X23: list @ A,P: ( list @ A ) > ( list @ A ) > $o] :
      ( ( lexordp_eq @ A @ Less @ X1 @ X23 )
     => ( ! [X_1: list @ A] : ( P @ ( nil @ A ) @ X_1 )
       => ( ! [X: A,Y3: A,Xs2: list @ A,Ys3: list @ A] :
              ( ( Less @ X @ Y3 )
             => ( P @ ( cons @ A @ X @ Xs2 ) @ ( cons @ A @ Y3 @ Ys3 ) ) )
         => ( ! [X: A,Y3: A,Xs2: list @ A,Ys3: list @ A] :
                ( ~ ( Less @ X @ Y3 )
               => ( ~ ( Less @ Y3 @ X )
                 => ( ( lexordp_eq @ A @ Less @ Xs2 @ Ys3 )
                   => ( ( P @ Xs2 @ Ys3 )
                     => ( P @ ( cons @ A @ X @ Xs2 ) @ ( cons @ A @ Y3 @ Ys3 ) ) ) ) ) )
           => ( P @ X1 @ X23 ) ) ) ) ) ).

% ord.lexordp_eq.inducts
thf(fact_83_ord_Olexordp__eq_Osimps,axiom,
    ! [A: $tType] :
      ( ( lexordp_eq @ A )
      = ( ^ [Less2: A > A > $o,A12: list @ A,A23: list @ A] :
            ( ? [Ys: list @ A] :
                ( ( A12
                  = ( nil @ A ) )
                & ( A23 = Ys ) )
            | ? [X4: A,Y2: A,Xs3: list @ A,Ys: list @ A] :
                ( ( A12
                  = ( cons @ A @ X4 @ Xs3 ) )
                & ( A23
                  = ( cons @ A @ Y2 @ Ys ) )
                & ( Less2 @ X4 @ Y2 ) )
            | ? [X4: A,Y2: A,Xs3: list @ A,Ys: list @ A] :
                ( ( A12
                  = ( cons @ A @ X4 @ Xs3 ) )
                & ( A23
                  = ( cons @ A @ Y2 @ Ys ) )
                & ~ ( Less2 @ X4 @ Y2 )
                & ~ ( Less2 @ Y2 @ X4 )
                & ( lexordp_eq @ A @ Less2 @ Xs3 @ Ys ) ) ) ) ) ).

% ord.lexordp_eq.simps
thf(fact_84_ord_Olexordp__eq_Ocases,axiom,
    ! [A: $tType,Less: A > A > $o,A1: list @ A,A22: list @ A] :
      ( ( lexordp_eq @ A @ Less @ A1 @ A22 )
     => ( ( A1
         != ( nil @ A ) )
       => ( ! [X: A] :
              ( ? [Xs2: list @ A] :
                  ( A1
                  = ( cons @ A @ X @ Xs2 ) )
             => ! [Y3: A] :
                  ( ? [Ys3: list @ A] :
                      ( A22
                      = ( cons @ A @ Y3 @ Ys3 ) )
                 => ~ ( Less @ X @ Y3 ) ) )
         => ~ ! [X: A,Y3: A,Xs2: list @ A] :
                ( ( A1
                  = ( cons @ A @ X @ Xs2 ) )
               => ! [Ys3: list @ A] :
                    ( ( A22
                      = ( cons @ A @ Y3 @ Ys3 ) )
                   => ( ~ ( Less @ X @ Y3 )
                     => ( ~ ( Less @ Y3 @ X )
                       => ~ ( lexordp_eq @ A @ Less @ Xs2 @ Ys3 ) ) ) ) ) ) ) ) ).

% ord.lexordp_eq.cases
thf(fact_85_mem_Osimps_I1_J,axiom,
    ! [A: $tType,X3: A] :
      ~ ( mem @ A @ X3 @ ( nil @ A ) ) ).

% mem.simps(1)
thf(fact_86_mem_Osimps_I2_J,axiom,
    ! [A: $tType,X3: A,Y: A,L: list @ A] :
      ( ( mem @ A @ X3 @ ( cons @ A @ Y @ L ) )
      = ( ( X3 = Y )
        | ( mem @ A @ X3 @ L ) ) ) ).

% mem.simps(2)
thf(fact_87_listrelp_Oinducts,axiom,
    ! [A: $tType,B: $tType,R: A > B > $o,X1: list @ A,X23: list @ B,P: ( list @ A ) > ( list @ B ) > $o] :
      ( ( listrelp @ A @ B @ R @ X1 @ X23 )
     => ( ( P @ ( nil @ A ) @ ( nil @ B ) )
       => ( ! [X: A,Y3: B,Xs2: list @ A,Ys3: list @ B] :
              ( ( R @ X @ Y3 )
             => ( ( listrelp @ A @ B @ R @ Xs2 @ Ys3 )
               => ( ( P @ Xs2 @ Ys3 )
                 => ( P @ ( cons @ A @ X @ Xs2 ) @ ( cons @ B @ Y3 @ Ys3 ) ) ) ) )
         => ( P @ X1 @ X23 ) ) ) ) ).

% listrelp.inducts
thf(fact_88_listrelp_Osimps,axiom,
    ! [B: $tType,A: $tType] :
      ( ( listrelp @ A @ B )
      = ( ^ [R2: A > B > $o,A12: list @ A,A23: list @ B] :
            ( ( ( A12
                = ( nil @ A ) )
              & ( A23
                = ( nil @ B ) ) )
            | ? [X4: A,Y2: B,Xs3: list @ A,Ys: list @ B] :
                ( ( A12
                  = ( cons @ A @ X4 @ Xs3 ) )
                & ( A23
                  = ( cons @ B @ Y2 @ Ys ) )
                & ( R2 @ X4 @ Y2 )
                & ( listrelp @ A @ B @ R2 @ Xs3 @ Ys ) ) ) ) ) ).

% listrelp.simps
thf(fact_89_listrelp_Ocases,axiom,
    ! [A: $tType,B: $tType,R: A > B > $o,A1: list @ A,A22: list @ B] :
      ( ( listrelp @ A @ B @ R @ A1 @ A22 )
     => ( ( ( A1
            = ( nil @ A ) )
         => ( A22
           != ( nil @ B ) ) )
       => ~ ! [X: A,Y3: B,Xs2: list @ A] :
              ( ( A1
                = ( cons @ A @ X @ Xs2 ) )
             => ! [Ys3: list @ B] :
                  ( ( A22
                    = ( cons @ B @ Y3 @ Ys3 ) )
                 => ( ( R @ X @ Y3 )
                   => ~ ( listrelp @ A @ B @ R @ Xs2 @ Ys3 ) ) ) ) ) ) ).

% listrelp.cases
thf(fact_90_lexordp__eq__simps_I3_J,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [X3: A,Xs: list @ A] :
          ~ ( ord_lexordp_eq @ A @ ( cons @ A @ X3 @ Xs ) @ ( nil @ A ) ) ) ).

% lexordp_eq_simps(3)
thf(fact_91_lexordp__eq__simps_I2_J,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [Xs: list @ A] :
          ( ( ord_lexordp_eq @ A @ Xs @ ( nil @ A ) )
          = ( Xs
            = ( nil @ A ) ) ) ) ).

% lexordp_eq_simps(2)
thf(fact_92_lexordp__eq__simps_I1_J,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [Ys2: list @ A] : ( ord_lexordp_eq @ A @ ( nil @ A ) @ Ys2 ) ) ).

% lexordp_eq_simps(1)
thf(fact_93_lexordp__eq__antisym,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [Xs: list @ A,Ys2: list @ A] :
          ( ( ord_lexordp_eq @ A @ Xs @ Ys2 )
         => ( ( ord_lexordp_eq @ A @ Ys2 @ Xs )
           => ( Xs = Ys2 ) ) ) ) ).

% lexordp_eq_antisym
thf(fact_94_lexordp__eq__linear,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [Xs: list @ A,Ys2: list @ A] :
          ( ( ord_lexordp_eq @ A @ Xs @ Ys2 )
          | ( ord_lexordp_eq @ A @ Ys2 @ Xs ) ) ) ).

% lexordp_eq_linear
thf(fact_95_lexordp__eq__trans,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [Xs: list @ A,Ys2: list @ A,Zs2: list @ A] :
          ( ( ord_lexordp_eq @ A @ Xs @ Ys2 )
         => ( ( ord_lexordp_eq @ A @ Ys2 @ Zs2 )
           => ( ord_lexordp_eq @ A @ Xs @ Zs2 ) ) ) ) ).

% lexordp_eq_trans
thf(fact_96_lexordp__eq__refl,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [Xs: list @ A] : ( ord_lexordp_eq @ A @ Xs @ Xs ) ) ).

% lexordp_eq_refl
thf(fact_97_lexordp__eq_ONil,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [Ys2: list @ A] : ( ord_lexordp_eq @ A @ ( nil @ A ) @ Ys2 ) ) ).

% lexordp_eq.Nil
thf(fact_98_listrelp_OCons,axiom,
    ! [A: $tType,B: $tType,R: A > B > $o,X3: A,Y: B,Xs: list @ A,Ys2: list @ B] :
      ( ( R @ X3 @ Y )
     => ( ( listrelp @ A @ B @ R @ Xs @ Ys2 )
       => ( listrelp @ A @ B @ R @ ( cons @ A @ X3 @ Xs ) @ ( cons @ B @ Y @ Ys2 ) ) ) ) ).

% listrelp.Cons
thf(fact_99_listrelp_ONil,axiom,
    ! [A: $tType,B: $tType,R: A > B > $o] : ( listrelp @ A @ B @ R @ ( nil @ A ) @ ( nil @ B ) ) ).

% listrelp.Nil
thf(fact_100_mem__memS__eq,axiom,
    ! [A: $tType] :
      ( ( mem @ A )
      = ( memS @ A ) ) ).

% mem_memS_eq
thf(fact_101_mem__notdisjoint,axiom,
    ! [A: $tType,X3: A,L1: list @ A,L2: list @ A] :
      ( ( mem @ A @ X3 @ L1 )
     => ( ( mem @ A @ X3 @ L2 )
       => ~ ( disjoint @ A @ L1 @ L2 ) ) ) ).

% mem_notdisjoint
thf(fact_102_mem__notdisjoint2,axiom,
    ! [A: $tType,B: $tType,Schedule: B > ( list @ A ),A2: B,B2: B,X3: A] :
      ( ( disjoint @ A @ ( Schedule @ A2 ) @ ( Schedule @ B2 ) )
     => ( ( mem @ A @ X3 @ ( Schedule @ A2 ) )
       => ~ ( mem @ A @ X3 @ ( Schedule @ B2 ) ) ) ) ).

% mem_notdisjoint2
thf(fact_103_lexordp__eq_Ocases,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [A1: list @ A,A22: list @ A] :
          ( ( ord_lexordp_eq @ A @ A1 @ A22 )
         => ( ( A1
             != ( nil @ A ) )
           => ( ! [X: A] :
                  ( ? [Xs2: list @ A] :
                      ( A1
                      = ( cons @ A @ X @ Xs2 ) )
                 => ! [Y3: A] :
                      ( ? [Ys3: list @ A] :
                          ( A22
                          = ( cons @ A @ Y3 @ Ys3 ) )
                     => ~ ( ord_less @ A @ X @ Y3 ) ) )
             => ~ ! [X: A,Y3: A,Xs2: list @ A] :
                    ( ( A1
                      = ( cons @ A @ X @ Xs2 ) )
                   => ! [Ys3: list @ A] :
                        ( ( A22
                          = ( cons @ A @ Y3 @ Ys3 ) )
                       => ( ~ ( ord_less @ A @ X @ Y3 )
                         => ( ~ ( ord_less @ A @ Y3 @ X )
                           => ~ ( ord_lexordp_eq @ A @ Xs2 @ Ys3 ) ) ) ) ) ) ) ) ) ).

% lexordp_eq.cases
thf(fact_104_lexordp__eq_Osimps,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ( ( ord_lexordp_eq @ A )
        = ( ^ [A12: list @ A,A23: list @ A] :
              ( ? [Ys: list @ A] :
                  ( ( A12
                    = ( nil @ A ) )
                  & ( A23 = Ys ) )
              | ? [X4: A,Y2: A,Xs3: list @ A,Ys: list @ A] :
                  ( ( A12
                    = ( cons @ A @ X4 @ Xs3 ) )
                  & ( A23
                    = ( cons @ A @ Y2 @ Ys ) )
                  & ( ord_less @ A @ X4 @ Y2 ) )
              | ? [X4: A,Y2: A,Xs3: list @ A,Ys: list @ A] :
                  ( ( A12
                    = ( cons @ A @ X4 @ Xs3 ) )
                  & ( A23
                    = ( cons @ A @ Y2 @ Ys ) )
                  & ~ ( ord_less @ A @ X4 @ Y2 )
                  & ~ ( ord_less @ A @ Y2 @ X4 )
                  & ( ord_lexordp_eq @ A @ Xs3 @ Ys ) ) ) ) ) ) ).

% lexordp_eq.simps
thf(fact_105_lexordp__eq__simps_I4_J,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [X3: A,Xs: list @ A,Y: A,Ys2: list @ A] :
          ( ( ord_lexordp_eq @ A @ ( cons @ A @ X3 @ Xs ) @ ( cons @ A @ Y @ Ys2 ) )
          = ( ( ord_less @ A @ X3 @ Y )
            | ( ~ ( ord_less @ A @ Y @ X3 )
              & ( ord_lexordp_eq @ A @ Xs @ Ys2 ) ) ) ) ) ).

% lexordp_eq_simps(4)
thf(fact_106_lexordp__eq_OCons__eq,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [X3: A,Y: A,Xs: list @ A,Ys2: list @ A] :
          ( ~ ( ord_less @ A @ X3 @ Y )
         => ( ~ ( ord_less @ A @ Y @ X3 )
           => ( ( ord_lexordp_eq @ A @ Xs @ Ys2 )
             => ( ord_lexordp_eq @ A @ ( cons @ A @ X3 @ Xs ) @ ( cons @ A @ Y @ Ys2 ) ) ) ) ) ) ).

% lexordp_eq.Cons_eq
thf(fact_107_lexordp__eq_OCons,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [X3: A,Y: A,Xs: list @ A,Ys2: list @ A] :
          ( ( ord_less @ A @ X3 @ Y )
         => ( ord_lexordp_eq @ A @ ( cons @ A @ X3 @ Xs ) @ ( cons @ A @ Y @ Ys2 ) ) ) ) ).

% lexordp_eq.Cons
thf(fact_108_lexordp__eq_Oinducts,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [X1: list @ A,X23: list @ A,P: ( list @ A ) > ( list @ A ) > $o] :
          ( ( ord_lexordp_eq @ A @ X1 @ X23 )
         => ( ! [X_1: list @ A] : ( P @ ( nil @ A ) @ X_1 )
           => ( ! [X: A,Y3: A,Xs2: list @ A,Ys3: list @ A] :
                  ( ( ord_less @ A @ X @ Y3 )
                 => ( P @ ( cons @ A @ X @ Xs2 ) @ ( cons @ A @ Y3 @ Ys3 ) ) )
             => ( ! [X: A,Y3: A,Xs2: list @ A,Ys3: list @ A] :
                    ( ~ ( ord_less @ A @ X @ Y3 )
                   => ( ~ ( ord_less @ A @ Y3 @ X )
                     => ( ( ord_lexordp_eq @ A @ Xs2 @ Ys3 )
                       => ( ( P @ Xs2 @ Ys3 )
                         => ( P @ ( cons @ A @ X @ Xs2 ) @ ( cons @ A @ Y3 @ Ys3 ) ) ) ) ) )
               => ( P @ X1 @ X23 ) ) ) ) ) ) ).

% lexordp_eq.inducts
thf(fact_109_lexordp_Ocases,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [A1: list @ A,A22: list @ A] :
          ( ( ord_lexordp @ A @ A1 @ A22 )
         => ( ( ( A1
                = ( nil @ A ) )
             => ! [Y3: A,Ys3: list @ A] :
                  ( A22
                 != ( cons @ A @ Y3 @ Ys3 ) ) )
           => ( ! [X: A] :
                  ( ? [Xs2: list @ A] :
                      ( A1
                      = ( cons @ A @ X @ Xs2 ) )
                 => ! [Y3: A] :
                      ( ? [Ys3: list @ A] :
                          ( A22
                          = ( cons @ A @ Y3 @ Ys3 ) )
                     => ~ ( ord_less @ A @ X @ Y3 ) ) )
             => ~ ! [X: A,Y3: A,Xs2: list @ A] :
                    ( ( A1
                      = ( cons @ A @ X @ Xs2 ) )
                   => ! [Ys3: list @ A] :
                        ( ( A22
                          = ( cons @ A @ Y3 @ Ys3 ) )
                       => ( ~ ( ord_less @ A @ X @ Y3 )
                         => ( ~ ( ord_less @ A @ Y3 @ X )
                           => ~ ( ord_lexordp @ A @ Xs2 @ Ys3 ) ) ) ) ) ) ) ) ) ).

% lexordp.cases
thf(fact_110_lexordp_Osimps,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ( ( ord_lexordp @ A )
        = ( ^ [A12: list @ A,A23: list @ A] :
              ( ? [Y2: A,Ys: list @ A] :
                  ( ( A12
                    = ( nil @ A ) )
                  & ( A23
                    = ( cons @ A @ Y2 @ Ys ) ) )
              | ? [X4: A,Y2: A,Xs3: list @ A,Ys: list @ A] :
                  ( ( A12
                    = ( cons @ A @ X4 @ Xs3 ) )
                  & ( A23
                    = ( cons @ A @ Y2 @ Ys ) )
                  & ( ord_less @ A @ X4 @ Y2 ) )
              | ? [X4: A,Y2: A,Xs3: list @ A,Ys: list @ A] :
                  ( ( A12
                    = ( cons @ A @ X4 @ Xs3 ) )
                  & ( A23
                    = ( cons @ A @ Y2 @ Ys ) )
                  & ~ ( ord_less @ A @ X4 @ Y2 )
                  & ~ ( ord_less @ A @ Y2 @ X4 )
                  & ( ord_lexordp @ A @ Xs3 @ Ys ) ) ) ) ) ) ).

% lexordp.simps
thf(fact_111_lexordp_Oinducts,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [X1: list @ A,X23: list @ A,P: ( list @ A ) > ( list @ A ) > $o] :
          ( ( ord_lexordp @ A @ X1 @ X23 )
         => ( ! [Y3: A,Ys3: list @ A] : ( P @ ( nil @ A ) @ ( cons @ A @ Y3 @ Ys3 ) )
           => ( ! [X: A,Y3: A,Xs2: list @ A,Ys3: list @ A] :
                  ( ( ord_less @ A @ X @ Y3 )
                 => ( P @ ( cons @ A @ X @ Xs2 ) @ ( cons @ A @ Y3 @ Ys3 ) ) )
             => ( ! [X: A,Y3: A,Xs2: list @ A,Ys3: list @ A] :
                    ( ~ ( ord_less @ A @ X @ Y3 )
                   => ( ~ ( ord_less @ A @ Y3 @ X )
                     => ( ( ord_lexordp @ A @ Xs2 @ Ys3 )
                       => ( ( P @ Xs2 @ Ys3 )
                         => ( P @ ( cons @ A @ X @ Xs2 ) @ ( cons @ A @ Y3 @ Ys3 ) ) ) ) ) )
               => ( P @ X1 @ X23 ) ) ) ) ) ) ).

% lexordp.inducts
thf(fact_112_lexordp__cases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [Xs: list @ A,Ys2: list @ A] :
          ( ( ord_lexordp @ A @ Xs @ Ys2 )
         => ( ( ( Xs
                = ( nil @ A ) )
             => ! [Y3: A,Ys4: list @ A] :
                  ( Ys2
                 != ( cons @ A @ Y3 @ Ys4 ) ) )
           => ( ! [X: A] :
                  ( ? [Xs4: list @ A] :
                      ( Xs
                      = ( cons @ A @ X @ Xs4 ) )
                 => ! [Y3: A] :
                      ( ? [Ys4: list @ A] :
                          ( Ys2
                          = ( cons @ A @ Y3 @ Ys4 ) )
                     => ~ ( ord_less @ A @ X @ Y3 ) ) )
             => ~ ! [X: A,Xs4: list @ A] :
                    ( ( Xs
                      = ( cons @ A @ X @ Xs4 ) )
                   => ! [Ys4: list @ A] :
                        ( ( Ys2
                          = ( cons @ A @ X @ Ys4 ) )
                       => ~ ( ord_lexordp @ A @ Xs4 @ Ys4 ) ) ) ) ) ) ) ).

% lexordp_cases
thf(fact_113_lexordp__induct,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [Xs: list @ A,Ys2: list @ A,P: ( list @ A ) > ( list @ A ) > $o] :
          ( ( ord_lexordp @ A @ Xs @ Ys2 )
         => ( ! [Y3: A,Ys3: list @ A] : ( P @ ( nil @ A ) @ ( cons @ A @ Y3 @ Ys3 ) )
           => ( ! [X: A,Xs2: list @ A,Y3: A,Ys3: list @ A] :
                  ( ( ord_less @ A @ X @ Y3 )
                 => ( P @ ( cons @ A @ X @ Xs2 ) @ ( cons @ A @ Y3 @ Ys3 ) ) )
             => ( ! [X: A,Xs2: list @ A,Ys3: list @ A] :
                    ( ( ord_lexordp @ A @ Xs2 @ Ys3 )
                   => ( ( P @ Xs2 @ Ys3 )
                     => ( P @ ( cons @ A @ X @ Xs2 ) @ ( cons @ A @ X @ Ys3 ) ) ) )
               => ( P @ Xs @ Ys2 ) ) ) ) ) ) ).

% lexordp_induct
thf(fact_114_lexordp__simps_I2_J,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [Xs: list @ A] :
          ~ ( ord_lexordp @ A @ Xs @ ( nil @ A ) ) ) ).

% lexordp_simps(2)
thf(fact_115_lexordp__simps_I1_J,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [Ys2: list @ A] :
          ( ( ord_lexordp @ A @ ( nil @ A ) @ Ys2 )
          = ( Ys2
           != ( nil @ A ) ) ) ) ).

% lexordp_simps(1)
thf(fact_116_lexordp__simps_I3_J,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [X3: A,Xs: list @ A,Y: A,Ys2: list @ A] :
          ( ( ord_lexordp @ A @ ( cons @ A @ X3 @ Xs ) @ ( cons @ A @ Y @ Ys2 ) )
          = ( ( ord_less @ A @ X3 @ Y )
            | ( ~ ( ord_less @ A @ Y @ X3 )
              & ( ord_lexordp @ A @ Xs @ Ys2 ) ) ) ) ) ).

% lexordp_simps(3)
thf(fact_117_lexordp__irreflexive_H,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [Xs: list @ A] :
          ~ ( ord_lexordp @ A @ Xs @ Xs ) ) ).

% lexordp_irreflexive'
thf(fact_118_lexordp__linear,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [Xs: list @ A,Ys2: list @ A] :
          ( ( ord_lexordp @ A @ Xs @ Ys2 )
          | ( Xs = Ys2 )
          | ( ord_lexordp @ A @ Ys2 @ Xs ) ) ) ).

% lexordp_linear
thf(fact_119_lexordp__trans,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [Xs: list @ A,Ys2: list @ A,Zs2: list @ A] :
          ( ( ord_lexordp @ A @ Xs @ Ys2 )
         => ( ( ord_lexordp @ A @ Ys2 @ Zs2 )
           => ( ord_lexordp @ A @ Xs @ Zs2 ) ) ) ) ).

% lexordp_trans
thf(fact_120_lexordp__antisym,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [Xs: list @ A,Ys2: list @ A] :
          ( ( ord_lexordp @ A @ Xs @ Ys2 )
         => ~ ( ord_lexordp @ A @ Ys2 @ Xs ) ) ) ).

% lexordp_antisym
thf(fact_121_lexordp__irreflexive,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [Xs: list @ A] :
          ( ! [X: A] :
              ~ ( ord_less @ A @ X @ X )
         => ~ ( ord_lexordp @ A @ Xs @ Xs ) ) ) ).

% lexordp_irreflexive
thf(fact_122_lexordp__conv__lexordp__eq,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ( ( ord_lexordp @ A )
        = ( ^ [Xs3: list @ A,Ys: list @ A] :
              ( ( ord_lexordp_eq @ A @ Xs3 @ Ys )
              & ~ ( ord_lexordp_eq @ A @ Ys @ Xs3 ) ) ) ) ) ).

% lexordp_conv_lexordp_eq
thf(fact_123_lexordp__eq__conv__lexord,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ( ( ord_lexordp_eq @ A )
        = ( ^ [Xs3: list @ A,Ys: list @ A] :
              ( ( Xs3 = Ys )
              | ( ord_lexordp @ A @ Xs3 @ Ys ) ) ) ) ) ).

% lexordp_eq_conv_lexord
thf(fact_124_lexordp__into__lexordp__eq,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [Xs: list @ A,Ys2: list @ A] :
          ( ( ord_lexordp @ A @ Xs @ Ys2 )
         => ( ord_lexordp_eq @ A @ Xs @ Ys2 ) ) ) ).

% lexordp_into_lexordp_eq
thf(fact_125_lexordp_OCons__eq,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [X3: A,Y: A,Xs: list @ A,Ys2: list @ A] :
          ( ~ ( ord_less @ A @ X3 @ Y )
         => ( ~ ( ord_less @ A @ Y @ X3 )
           => ( ( ord_lexordp @ A @ Xs @ Ys2 )
             => ( ord_lexordp @ A @ ( cons @ A @ X3 @ Xs ) @ ( cons @ A @ Y @ Ys2 ) ) ) ) ) ) ).

% lexordp.Cons_eq
thf(fact_126_lexordp_OCons,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [X3: A,Y: A,Xs: list @ A,Ys2: list @ A] :
          ( ( ord_less @ A @ X3 @ Y )
         => ( ord_lexordp @ A @ ( cons @ A @ X3 @ Xs ) @ ( cons @ A @ Y @ Ys2 ) ) ) ) ).

% lexordp.Cons
thf(fact_127_lexordp_ONil,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [Y: A,Ys2: list @ A] : ( ord_lexordp @ A @ ( nil @ A ) @ ( cons @ A @ Y @ Ys2 ) ) ) ).

% lexordp.Nil
thf(fact_128_member__rec_I2_J,axiom,
    ! [A: $tType,Y: A] :
      ~ ( member @ A @ ( nil @ A ) @ Y ) ).

% member_rec(2)
thf(fact_129_member__rec_I1_J,axiom,
    ! [A: $tType,X3: A,Xs: list @ A,Y: A] :
      ( ( member @ A @ ( cons @ A @ X3 @ Xs ) @ Y )
      = ( ( X3 = Y )
        | ( member @ A @ Xs @ Y ) ) ) ).

% member_rec(1)
thf(fact_130_splice_Oelims,axiom,
    ! [A: $tType,X3: list @ A,Xa: list @ A,Y: list @ A] :
      ( ( ( splice @ A @ X3 @ Xa )
        = Y )
     => ( ( ( X3
            = ( nil @ A ) )
         => ( Y != Xa ) )
       => ~ ! [X: A,Xs2: list @ A] :
              ( ( X3
                = ( cons @ A @ X @ Xs2 ) )
             => ( Y
               != ( cons @ A @ X @ ( splice @ A @ Xa @ Xs2 ) ) ) ) ) ) ).

% splice.elims
thf(fact_131_lexordp__iff,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ( ( ord_lexordp @ A )
        = ( ^ [Xs3: list @ A,Ys: list @ A] :
              ( ? [X4: A,Vs: list @ A] :
                  ( Ys
                  = ( append @ A @ Xs3 @ ( cons @ A @ X4 @ Vs ) ) )
              | ? [Us: list @ A,A5: A,B3: A,Vs: list @ A,Ws: list @ A] :
                  ( ( ord_less @ A @ A5 @ B3 )
                  & ( Xs3
                    = ( append @ A @ Us @ ( cons @ A @ A5 @ Vs ) ) )
                  & ( Ys
                    = ( append @ A @ Us @ ( cons @ A @ B3 @ Ws ) ) ) ) ) ) ) ) ).

% lexordp_iff
thf(fact_132_append_Oassoc,axiom,
    ! [A: $tType,A4: list @ A,B4: list @ A,C3: list @ A] :
      ( ( append @ A @ ( append @ A @ A4 @ B4 ) @ C3 )
      = ( append @ A @ A4 @ ( append @ A @ B4 @ C3 ) ) ) ).

% append.assoc
thf(fact_133_append__assoc,axiom,
    ! [A: $tType,Xs: list @ A,Ys2: list @ A,Zs2: list @ A] :
      ( ( append @ A @ ( append @ A @ Xs @ Ys2 ) @ Zs2 )
      = ( append @ A @ Xs @ ( append @ A @ Ys2 @ Zs2 ) ) ) ).

% append_assoc
thf(fact_134_append__same__eq,axiom,
    ! [A: $tType,Ys2: list @ A,Xs: list @ A,Zs2: list @ A] :
      ( ( ( append @ A @ Ys2 @ Xs )
        = ( append @ A @ Zs2 @ Xs ) )
      = ( Ys2 = Zs2 ) ) ).

% append_same_eq
thf(fact_135_same__append__eq,axiom,
    ! [A: $tType,Xs: list @ A,Ys2: list @ A,Zs2: list @ A] :
      ( ( ( append @ A @ Xs @ Ys2 )
        = ( append @ A @ Xs @ Zs2 ) )
      = ( Ys2 = Zs2 ) ) ).

% same_append_eq
thf(fact_136_append_Oright__neutral,axiom,
    ! [A: $tType,A4: list @ A] :
      ( ( append @ A @ A4 @ ( nil @ A ) )
      = A4 ) ).

% append.right_neutral
thf(fact_137_append__is__Nil__conv,axiom,
    ! [A: $tType,Xs: list @ A,Ys2: list @ A] :
      ( ( ( append @ A @ Xs @ Ys2 )
        = ( nil @ A ) )
      = ( ( Xs
          = ( nil @ A ) )
        & ( Ys2
          = ( nil @ A ) ) ) ) ).

% append_is_Nil_conv
thf(fact_138_Nil__is__append__conv,axiom,
    ! [A: $tType,Xs: list @ A,Ys2: list @ A] :
      ( ( ( nil @ A )
        = ( append @ A @ Xs @ Ys2 ) )
      = ( ( Xs
          = ( nil @ A ) )
        & ( Ys2
          = ( nil @ A ) ) ) ) ).

% Nil_is_append_conv
thf(fact_139_self__append__conv2,axiom,
    ! [A: $tType,Ys2: list @ A,Xs: list @ A] :
      ( ( Ys2
        = ( append @ A @ Xs @ Ys2 ) )
      = ( Xs
        = ( nil @ A ) ) ) ).

% self_append_conv2
thf(fact_140_append__self__conv2,axiom,
    ! [A: $tType,Xs: list @ A,Ys2: list @ A] :
      ( ( ( append @ A @ Xs @ Ys2 )
        = Ys2 )
      = ( Xs
        = ( nil @ A ) ) ) ).

% append_self_conv2
thf(fact_141_self__append__conv,axiom,
    ! [A: $tType,Xs: list @ A,Ys2: list @ A] :
      ( ( Xs
        = ( append @ A @ Xs @ Ys2 ) )
      = ( Ys2
        = ( nil @ A ) ) ) ).

% self_append_conv
thf(fact_142_append__self__conv,axiom,
    ! [A: $tType,Xs: list @ A,Ys2: list @ A] :
      ( ( ( append @ A @ Xs @ Ys2 )
        = Xs )
      = ( Ys2
        = ( nil @ A ) ) ) ).

% append_self_conv
thf(fact_143_append__Nil2,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( append @ A @ Xs @ ( nil @ A ) )
      = Xs ) ).

% append_Nil2
thf(fact_144_split__Nil__iff,axiom,
    ! [A: $tType,Xs: list @ A,Ys2: list @ A] :
      ( ( ( splice @ A @ Xs @ Ys2 )
        = ( nil @ A ) )
      = ( ( Xs
          = ( nil @ A ) )
        & ( Ys2
          = ( nil @ A ) ) ) ) ).

% split_Nil_iff
thf(fact_145_splice__Nil2,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( splice @ A @ Xs @ ( nil @ A ) )
      = Xs ) ).

% splice_Nil2
thf(fact_146_append1__eq__conv,axiom,
    ! [A: $tType,Xs: list @ A,X3: A,Ys2: list @ A,Y: A] :
      ( ( ( append @ A @ Xs @ ( cons @ A @ X3 @ ( nil @ A ) ) )
        = ( append @ A @ Ys2 @ ( cons @ A @ Y @ ( nil @ A ) ) ) )
      = ( ( Xs = Ys2 )
        & ( X3 = Y ) ) ) ).

% append1_eq_conv
thf(fact_147_bind__simps_I2_J,axiom,
    ! [A: $tType,B: $tType,X3: B,Xs: list @ B,F3: B > ( list @ A )] :
      ( ( bind @ B @ A @ ( cons @ B @ X3 @ Xs ) @ F3 )
      = ( append @ A @ ( F3 @ X3 ) @ ( bind @ B @ A @ Xs @ F3 ) ) ) ).

% bind_simps(2)
thf(fact_148_lexordp__append__leftI,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [Us2: list @ A,Vs2: list @ A,Xs: list @ A] :
          ( ( ord_lexordp @ A @ Us2 @ Vs2 )
         => ( ord_lexordp @ A @ ( append @ A @ Xs @ Us2 ) @ ( append @ A @ Xs @ Vs2 ) ) ) ) ).

% lexordp_append_leftI
thf(fact_149_append__eq__appendI,axiom,
    ! [A: $tType,Xs: list @ A,Xs1: list @ A,Zs2: list @ A,Ys2: list @ A,Us2: list @ A] :
      ( ( ( append @ A @ Xs @ Xs1 )
        = Zs2 )
     => ( ( Ys2
          = ( append @ A @ Xs1 @ Us2 ) )
       => ( ( append @ A @ Xs @ Ys2 )
          = ( append @ A @ Zs2 @ Us2 ) ) ) ) ).

% append_eq_appendI
thf(fact_150_append__eq__append__conv2,axiom,
    ! [A: $tType,Xs: list @ A,Ys2: list @ A,Zs2: list @ A,Ts: list @ A] :
      ( ( ( append @ A @ Xs @ Ys2 )
        = ( append @ A @ Zs2 @ Ts ) )
      = ( ? [Us: list @ A] :
            ( ( ( Xs
                = ( append @ A @ Zs2 @ Us ) )
              & ( ( append @ A @ Us @ Ys2 )
                = Ts ) )
            | ( ( ( append @ A @ Xs @ Us )
                = Zs2 )
              & ( Ys2
                = ( append @ A @ Us @ Ts ) ) ) ) ) ) ).

% append_eq_append_conv2
thf(fact_151_eq__Nil__appendI,axiom,
    ! [A: $tType,Xs: list @ A,Ys2: list @ A] :
      ( ( Xs = Ys2 )
     => ( Xs
        = ( append @ A @ ( nil @ A ) @ Ys2 ) ) ) ).

% eq_Nil_appendI
thf(fact_152_append__Nil,axiom,
    ! [A: $tType,Ys2: list @ A] :
      ( ( append @ A @ ( nil @ A ) @ Ys2 )
      = Ys2 ) ).

% append_Nil
thf(fact_153_append_Oleft__neutral,axiom,
    ! [A: $tType,A4: list @ A] :
      ( ( append @ A @ ( nil @ A ) @ A4 )
      = A4 ) ).

% append.left_neutral
thf(fact_154_Cons__eq__appendI,axiom,
    ! [A: $tType,X3: A,Xs1: list @ A,Ys2: list @ A,Xs: list @ A,Zs2: list @ A] :
      ( ( ( cons @ A @ X3 @ Xs1 )
        = Ys2 )
     => ( ( Xs
          = ( append @ A @ Xs1 @ Zs2 ) )
       => ( ( cons @ A @ X3 @ Xs )
          = ( append @ A @ Ys2 @ Zs2 ) ) ) ) ).

% Cons_eq_appendI
thf(fact_155_append__Cons,axiom,
    ! [A: $tType,X3: A,Xs: list @ A,Ys2: list @ A] :
      ( ( append @ A @ ( cons @ A @ X3 @ Xs ) @ Ys2 )
      = ( cons @ A @ X3 @ ( append @ A @ Xs @ Ys2 ) ) ) ).

% append_Cons
thf(fact_156_lexordp__eq__pref,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [U: list @ A,V: list @ A] : ( ord_lexordp_eq @ A @ U @ ( append @ A @ U @ V ) ) ) ).

% lexordp_eq_pref
thf(fact_157_ord_Olexordp__eq__pref,axiom,
    ! [A: $tType,Less: A > A > $o,U: list @ A,V: list @ A] : ( lexordp_eq @ A @ Less @ U @ ( append @ A @ U @ V ) ) ).

% ord.lexordp_eq_pref
thf(fact_158_knows2b,axiom,
    ! [A2: secrecy_specID,E: list @ secrecy_Expression,E1: list @ secrecy_Expression] :
      ( ( knowle2055185861_knows @ A2 @ ( append @ secrecy_Expression @ E @ E1 ) )
     => ( knowle2055185861_knows @ A2 @ E ) ) ).

% knows2b
thf(fact_159_knows2a,axiom,
    ! [A2: secrecy_specID,E1: list @ secrecy_Expression,E: list @ secrecy_Expression] :
      ( ( knowle2055185861_knows @ A2 @ ( append @ secrecy_Expression @ E1 @ E ) )
     => ( knowle2055185861_knows @ A2 @ E ) ) ).

% knows2a
thf(fact_160_knows3,axiom,
    ! [A2: secrecy_specID,E1: list @ secrecy_Expression,E22: list @ secrecy_Expression] :
      ( ( ( knowle2055185861_knows @ A2 @ E1 )
        & ( knowle2055185861_knows @ A2 @ E22 ) )
     => ( knowle2055185861_knows @ A2 @ ( append @ secrecy_Expression @ E1 @ E22 ) ) ) ).

% knows3
thf(fact_161_splice_Osimps_I2_J,axiom,
    ! [A: $tType,X3: A,Xs: list @ A,Ys2: list @ A] :
      ( ( splice @ A @ ( cons @ A @ X3 @ Xs ) @ Ys2 )
      = ( cons @ A @ X3 @ ( splice @ A @ Ys2 @ Xs ) ) ) ).

% splice.simps(2)
thf(fact_162_splice_Osimps_I1_J,axiom,
    ! [A: $tType,Ys2: list @ A] :
      ( ( splice @ A @ ( nil @ A ) @ Ys2 )
      = Ys2 ) ).

% splice.simps(1)
thf(fact_163_rev__nonempty__induct,axiom,
    ! [A: $tType,Xs: list @ A,P: ( list @ A ) > $o] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ! [X: A] : ( P @ ( cons @ A @ X @ ( nil @ A ) ) )
       => ( ! [X: A,Xs2: list @ A] :
              ( ( Xs2
               != ( nil @ A ) )
             => ( ( P @ Xs2 )
               => ( P @ ( append @ A @ Xs2 @ ( cons @ A @ X @ ( nil @ A ) ) ) ) ) )
         => ( P @ Xs ) ) ) ) ).

% rev_nonempty_induct
thf(fact_164_append__eq__Cons__conv,axiom,
    ! [A: $tType,Ys2: list @ A,Zs2: list @ A,X3: A,Xs: list @ A] :
      ( ( ( append @ A @ Ys2 @ Zs2 )
        = ( cons @ A @ X3 @ Xs ) )
      = ( ( ( Ys2
            = ( nil @ A ) )
          & ( Zs2
            = ( cons @ A @ X3 @ Xs ) ) )
        | ? [Ys5: list @ A] :
            ( ( Ys2
              = ( cons @ A @ X3 @ Ys5 ) )
            & ( ( append @ A @ Ys5 @ Zs2 )
              = Xs ) ) ) ) ).

% append_eq_Cons_conv
thf(fact_165_Cons__eq__append__conv,axiom,
    ! [A: $tType,X3: A,Xs: list @ A,Ys2: list @ A,Zs2: list @ A] :
      ( ( ( cons @ A @ X3 @ Xs )
        = ( append @ A @ Ys2 @ Zs2 ) )
      = ( ( ( Ys2
            = ( nil @ A ) )
          & ( ( cons @ A @ X3 @ Xs )
            = Zs2 ) )
        | ? [Ys5: list @ A] :
            ( ( ( cons @ A @ X3 @ Ys5 )
              = Ys2 )
            & ( Xs
              = ( append @ A @ Ys5 @ Zs2 ) ) ) ) ) ).

% Cons_eq_append_conv
thf(fact_166_rev__exhaust,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( Xs
       != ( nil @ A ) )
     => ~ ! [Ys3: list @ A,Y3: A] :
            ( Xs
           != ( append @ A @ Ys3 @ ( cons @ A @ Y3 @ ( nil @ A ) ) ) ) ) ).

% rev_exhaust
thf(fact_167_rev__induct,axiom,
    ! [A: $tType,P: ( list @ A ) > $o,Xs: list @ A] :
      ( ( P @ ( nil @ A ) )
     => ( ! [X: A,Xs2: list @ A] :
            ( ( P @ Xs2 )
           => ( P @ ( append @ A @ Xs2 @ ( cons @ A @ X @ ( nil @ A ) ) ) ) )
       => ( P @ Xs ) ) ) ).

% rev_induct
thf(fact_168_lexordp__append__leftD,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [Xs: list @ A,Us2: list @ A,Vs2: list @ A] :
          ( ( ord_lexordp @ A @ ( append @ A @ Xs @ Us2 ) @ ( append @ A @ Xs @ Vs2 ) )
         => ( ! [A3: A] :
                ~ ( ord_less @ A @ A3 @ A3 )
           => ( ord_lexordp @ A @ Us2 @ Vs2 ) ) ) ) ).

% lexordp_append_leftD
thf(fact_169_lexordp__append__rightI,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [Ys2: list @ A,Xs: list @ A] :
          ( ( Ys2
           != ( nil @ A ) )
         => ( ord_lexordp @ A @ Xs @ ( append @ A @ Xs @ Ys2 ) ) ) ) ).

% lexordp_append_rightI
thf(fact_170_lexordp__append__left__rightI,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [X3: A,Y: A,Us2: list @ A,Xs: list @ A,Ys2: list @ A] :
          ( ( ord_less @ A @ X3 @ Y )
         => ( ord_lexordp @ A @ ( append @ A @ Us2 @ ( cons @ A @ X3 @ Xs ) ) @ ( append @ A @ Us2 @ ( cons @ A @ Y @ Ys2 ) ) ) ) ) ).

% lexordp_append_left_rightI
thf(fact_171_maps__simps_I1_J,axiom,
    ! [A: $tType,B: $tType,F3: B > ( list @ A ),X3: B,Xs: list @ B] :
      ( ( maps @ B @ A @ F3 @ ( cons @ B @ X3 @ Xs ) )
      = ( append @ A @ ( F3 @ X3 ) @ ( maps @ B @ A @ F3 @ Xs ) ) ) ).

% maps_simps(1)
thf(fact_172_concat__eq__append__conv,axiom,
    ! [A: $tType,Xss2: list @ ( list @ A ),Ys2: list @ A,Zs2: list @ A] :
      ( ( ( concat @ A @ Xss2 )
        = ( append @ A @ Ys2 @ Zs2 ) )
      = ( ( ( Xss2
            = ( nil @ ( list @ A ) ) )
         => ( ( Ys2
              = ( nil @ A ) )
            & ( Zs2
              = ( nil @ A ) ) ) )
        & ( ( Xss2
           != ( nil @ ( list @ A ) ) )
         => ? [Xss1: list @ ( list @ A ),Xs3: list @ A,Xs5: list @ A,Xss22: list @ ( list @ A )] :
              ( ( Xss2
                = ( append @ ( list @ A ) @ Xss1 @ ( cons @ ( list @ A ) @ ( append @ A @ Xs3 @ Xs5 ) @ Xss22 ) ) )
              & ( Ys2
                = ( append @ A @ ( concat @ A @ Xss1 ) @ Xs3 ) )
              & ( Zs2
                = ( append @ A @ Xs5 @ ( concat @ A @ Xss22 ) ) ) ) ) ) ) ).

% concat_eq_append_conv
thf(fact_173_rotate1_Osimps_I2_J,axiom,
    ! [A: $tType,X3: A,Xs: list @ A] :
      ( ( rotate1 @ A @ ( cons @ A @ X3 @ Xs ) )
      = ( append @ A @ Xs @ ( cons @ A @ X3 @ ( nil @ A ) ) ) ) ).

% rotate1.simps(2)
thf(fact_174_butlast__snoc,axiom,
    ! [A: $tType,Xs: list @ A,X3: A] :
      ( ( butlast @ A @ ( append @ A @ Xs @ ( cons @ A @ X3 @ ( nil @ A ) ) ) )
      = Xs ) ).

% butlast_snoc
thf(fact_175_rotate1__is__Nil__conv,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( ( rotate1 @ A @ Xs )
        = ( nil @ A ) )
      = ( Xs
        = ( nil @ A ) ) ) ).

% rotate1_is_Nil_conv
thf(fact_176_concat__append,axiom,
    ! [A: $tType,Xs: list @ ( list @ A ),Ys2: list @ ( list @ A )] :
      ( ( concat @ A @ ( append @ ( list @ A ) @ Xs @ Ys2 ) )
      = ( append @ A @ ( concat @ A @ Xs ) @ ( concat @ A @ Ys2 ) ) ) ).

% concat_append
thf(fact_177_butlast_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( butlast @ A @ ( nil @ A ) )
      = ( nil @ A ) ) ).

% butlast.simps(1)
thf(fact_178_rotate1_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( rotate1 @ A @ ( nil @ A ) )
      = ( nil @ A ) ) ).

% rotate1.simps(1)
thf(fact_179_butlast_Osimps_I2_J,axiom,
    ! [A: $tType,Xs: list @ A,X3: A] :
      ( ( ( Xs
          = ( nil @ A ) )
       => ( ( butlast @ A @ ( cons @ A @ X3 @ Xs ) )
          = ( nil @ A ) ) )
      & ( ( Xs
         != ( nil @ A ) )
       => ( ( butlast @ A @ ( cons @ A @ X3 @ Xs ) )
          = ( cons @ A @ X3 @ ( butlast @ A @ Xs ) ) ) ) ) ).

% butlast.simps(2)
thf(fact_180_concat_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( concat @ A @ ( nil @ ( list @ A ) ) )
      = ( nil @ A ) ) ).

% concat.simps(1)
thf(fact_181_butlast__append,axiom,
    ! [A: $tType,Ys2: list @ A,Xs: list @ A] :
      ( ( ( Ys2
          = ( nil @ A ) )
       => ( ( butlast @ A @ ( append @ A @ Xs @ Ys2 ) )
          = ( butlast @ A @ Xs ) ) )
      & ( ( Ys2
         != ( nil @ A ) )
       => ( ( butlast @ A @ ( append @ A @ Xs @ Ys2 ) )
          = ( append @ A @ Xs @ ( butlast @ A @ Ys2 ) ) ) ) ) ).

% butlast_append
thf(fact_182_concat_Osimps_I2_J,axiom,
    ! [A: $tType,X3: list @ A,Xs: list @ ( list @ A )] :
      ( ( concat @ A @ ( cons @ ( list @ A ) @ X3 @ Xs ) )
      = ( append @ A @ X3 @ ( concat @ A @ Xs ) ) ) ).

% concat.simps(2)
thf(fact_183_maps__simps_I2_J,axiom,
    ! [B: $tType,A: $tType,F3: B > ( list @ A )] :
      ( ( maps @ B @ A @ F3 @ ( nil @ B ) )
      = ( nil @ A ) ) ).

% maps_simps(2)
thf(fact_184_concat__eq__appendD,axiom,
    ! [A: $tType,Xss2: list @ ( list @ A ),Ys2: list @ A,Zs2: list @ A] :
      ( ( ( concat @ A @ Xss2 )
        = ( append @ A @ Ys2 @ Zs2 ) )
     => ( ( Xss2
         != ( nil @ ( list @ A ) ) )
       => ? [Xss12: list @ ( list @ A ),Xs2: list @ A,Xs4: list @ A,Xss23: list @ ( list @ A )] :
            ( ( Xss2
              = ( append @ ( list @ A ) @ Xss12 @ ( cons @ ( list @ A ) @ ( append @ A @ Xs2 @ Xs4 ) @ Xss23 ) ) )
            & ( Ys2
              = ( append @ A @ ( concat @ A @ Xss12 ) @ Xs2 ) )
            & ( Zs2
              = ( append @ A @ Xs4 @ ( concat @ A @ Xss23 ) ) ) ) ) ) ).

% concat_eq_appendD
thf(fact_185_append__butlast__last__id,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ( append @ A @ ( butlast @ A @ Xs ) @ ( cons @ A @ ( last @ A @ Xs ) @ ( nil @ A ) ) )
        = Xs ) ) ).

% append_butlast_last_id
thf(fact_186_snoc__eq__iff__butlast,axiom,
    ! [A: $tType,Xs: list @ A,X3: A,Ys2: list @ A] :
      ( ( ( append @ A @ Xs @ ( cons @ A @ X3 @ ( nil @ A ) ) )
        = Ys2 )
      = ( ( Ys2
         != ( nil @ A ) )
        & ( ( butlast @ A @ Ys2 )
          = Xs )
        & ( ( last @ A @ Ys2 )
          = X3 ) ) ) ).

% snoc_eq_iff_butlast
thf(fact_187_last__snoc,axiom,
    ! [A: $tType,Xs: list @ A,X3: A] :
      ( ( last @ A @ ( append @ A @ Xs @ ( cons @ A @ X3 @ ( nil @ A ) ) ) )
      = X3 ) ).

% last_snoc
thf(fact_188_last__appendR,axiom,
    ! [A: $tType,Ys2: list @ A,Xs: list @ A] :
      ( ( Ys2
       != ( nil @ A ) )
     => ( ( last @ A @ ( append @ A @ Xs @ Ys2 ) )
        = ( last @ A @ Ys2 ) ) ) ).

% last_appendR
thf(fact_189_last__appendL,axiom,
    ! [A: $tType,Ys2: list @ A,Xs: list @ A] :
      ( ( Ys2
        = ( nil @ A ) )
     => ( ( last @ A @ ( append @ A @ Xs @ Ys2 ) )
        = ( last @ A @ Xs ) ) ) ).

% last_appendL
thf(fact_190_last__ConsR,axiom,
    ! [A: $tType,Xs: list @ A,X3: A] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ( last @ A @ ( cons @ A @ X3 @ Xs ) )
        = ( last @ A @ Xs ) ) ) ).

% last_ConsR
thf(fact_191_last__ConsL,axiom,
    ! [A: $tType,Xs: list @ A,X3: A] :
      ( ( Xs
        = ( nil @ A ) )
     => ( ( last @ A @ ( cons @ A @ X3 @ Xs ) )
        = X3 ) ) ).

% last_ConsL
thf(fact_192_last_Osimps,axiom,
    ! [A: $tType,Xs: list @ A,X3: A] :
      ( ( ( Xs
          = ( nil @ A ) )
       => ( ( last @ A @ ( cons @ A @ X3 @ Xs ) )
          = X3 ) )
      & ( ( Xs
         != ( nil @ A ) )
       => ( ( last @ A @ ( cons @ A @ X3 @ Xs ) )
          = ( last @ A @ Xs ) ) ) ) ).

% last.simps
thf(fact_193_last__append,axiom,
    ! [A: $tType,Ys2: list @ A,Xs: list @ A] :
      ( ( ( Ys2
          = ( nil @ A ) )
       => ( ( last @ A @ ( append @ A @ Xs @ Ys2 ) )
          = ( last @ A @ Xs ) ) )
      & ( ( Ys2
         != ( nil @ A ) )
       => ( ( last @ A @ ( append @ A @ Xs @ Ys2 ) )
          = ( last @ A @ Ys2 ) ) ) ) ).

% last_append
thf(fact_194_longest__common__suffix,axiom,
    ! [A: $tType,Xs: list @ A,Ys2: list @ A] :
    ? [Ss: list @ A,Xs4: list @ A,Ys4: list @ A] :
      ( ( Xs
        = ( append @ A @ Xs4 @ Ss ) )
      & ( Ys2
        = ( append @ A @ Ys4 @ Ss ) )
      & ( ( Xs4
          = ( nil @ A ) )
        | ( Ys4
          = ( nil @ A ) )
        | ( ( last @ A @ Xs4 )
         != ( last @ A @ Ys4 ) ) ) ) ).

% longest_common_suffix
thf(fact_195_concat__conv__foldr,axiom,
    ! [A: $tType] :
      ( ( concat @ A )
      = ( ^ [Xss3: list @ ( list @ A )] : ( foldr @ ( list @ A ) @ ( list @ A ) @ ( append @ A ) @ Xss3 @ ( nil @ A ) ) ) ) ).

% concat_conv_foldr
thf(fact_196_SuccD,axiom,
    ! [A: $tType,K: A,Kl: set @ ( list @ A ),Kl2: list @ A] :
      ( ( member2 @ A @ K @ ( bNF_Greatest_Succ @ A @ Kl @ Kl2 ) )
     => ( member2 @ ( list @ A ) @ ( append @ A @ Kl2 @ ( cons @ A @ K @ ( nil @ A ) ) ) @ Kl ) ) ).

% SuccD
thf(fact_197_foldr__append,axiom,
    ! [B: $tType,A: $tType,F3: B > A > A,Xs: list @ B,Ys2: list @ B,A4: A] :
      ( ( foldr @ B @ A @ F3 @ ( append @ B @ Xs @ Ys2 ) @ A4 )
      = ( foldr @ B @ A @ F3 @ Xs @ ( foldr @ B @ A @ F3 @ Ys2 @ A4 ) ) ) ).

% foldr_append
thf(fact_198_SuccI,axiom,
    ! [A: $tType,Kl2: list @ A,K: A,Kl: set @ ( list @ A )] :
      ( ( member2 @ ( list @ A ) @ ( append @ A @ Kl2 @ ( cons @ A @ K @ ( nil @ A ) ) ) @ Kl )
     => ( member2 @ A @ K @ ( bNF_Greatest_Succ @ A @ Kl @ Kl2 ) ) ) ).

% SuccI
thf(fact_199_shift__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( bNF_Greatest_shift @ A @ B )
      = ( ^ [Lab: ( list @ A ) > B,K3: A,Kl3: list @ A] : ( Lab @ ( cons @ A @ K3 @ Kl3 ) ) ) ) ).

% shift_def
thf(fact_200_empty__Shift,axiom,
    ! [A: $tType,Kl: set @ ( list @ A ),K: A] :
      ( ( member2 @ ( list @ A ) @ ( nil @ A ) @ Kl )
     => ( ( member2 @ A @ K @ ( bNF_Greatest_Succ @ A @ Kl @ ( nil @ A ) ) )
       => ( member2 @ ( list @ A ) @ ( nil @ A ) @ ( bNF_Greatest_Shift @ A @ Kl @ K ) ) ) ) ).

% empty_Shift
thf(fact_201_ShiftD,axiom,
    ! [A: $tType,Kl2: list @ A,Kl: set @ ( list @ A ),K: A] :
      ( ( member2 @ ( list @ A ) @ Kl2 @ ( bNF_Greatest_Shift @ A @ Kl @ K ) )
     => ( member2 @ ( list @ A ) @ ( cons @ A @ K @ Kl2 ) @ Kl ) ) ).

% ShiftD
thf(fact_202_Succ__Shift,axiom,
    ! [A: $tType,Kl: set @ ( list @ A ),K: A,Kl2: list @ A] :
      ( ( bNF_Greatest_Succ @ A @ ( bNF_Greatest_Shift @ A @ Kl @ K ) @ Kl2 )
      = ( bNF_Greatest_Succ @ A @ Kl @ ( cons @ A @ K @ Kl2 ) ) ) ).

% Succ_Shift
thf(fact_203_rev__eq__Cons__iff,axiom,
    ! [A: $tType,Xs: list @ A,Y: A,Ys2: list @ A] :
      ( ( ( rev @ A @ Xs )
        = ( cons @ A @ Y @ Ys2 ) )
      = ( Xs
        = ( append @ A @ ( rev @ A @ Ys2 ) @ ( cons @ A @ Y @ ( nil @ A ) ) ) ) ) ).

% rev_eq_Cons_iff
thf(fact_204_append_Omonoid__axioms,axiom,
    ! [A: $tType] : ( monoid @ ( list @ A ) @ ( append @ A ) @ ( nil @ A ) ) ).

% append.monoid_axioms
thf(fact_205_rev__is__rev__conv,axiom,
    ! [A: $tType,Xs: list @ A,Ys2: list @ A] :
      ( ( ( rev @ A @ Xs )
        = ( rev @ A @ Ys2 ) )
      = ( Xs = Ys2 ) ) ).

% rev_is_rev_conv
thf(fact_206_rev__rev__ident,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( rev @ A @ ( rev @ A @ Xs ) )
      = Xs ) ).

% rev_rev_ident
thf(fact_207_rev__is__Nil__conv,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( ( rev @ A @ Xs )
        = ( nil @ A ) )
      = ( Xs
        = ( nil @ A ) ) ) ).

% rev_is_Nil_conv
thf(fact_208_Nil__is__rev__conv,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( ( nil @ A )
        = ( rev @ A @ Xs ) )
      = ( Xs
        = ( nil @ A ) ) ) ).

% Nil_is_rev_conv
thf(fact_209_rev__append,axiom,
    ! [A: $tType,Xs: list @ A,Ys2: list @ A] :
      ( ( rev @ A @ ( append @ A @ Xs @ Ys2 ) )
      = ( append @ A @ ( rev @ A @ Ys2 ) @ ( rev @ A @ Xs ) ) ) ).

% rev_append
thf(fact_210_singleton__rev__conv,axiom,
    ! [A: $tType,X3: A,Xs: list @ A] :
      ( ( ( cons @ A @ X3 @ ( nil @ A ) )
        = ( rev @ A @ Xs ) )
      = ( Xs
        = ( cons @ A @ X3 @ ( nil @ A ) ) ) ) ).

% singleton_rev_conv
thf(fact_211_rev__singleton__conv,axiom,
    ! [A: $tType,Xs: list @ A,X3: A] :
      ( ( ( rev @ A @ Xs )
        = ( cons @ A @ X3 @ ( nil @ A ) ) )
      = ( Xs
        = ( cons @ A @ X3 @ ( nil @ A ) ) ) ) ).

% rev_singleton_conv
thf(fact_212_rev_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( rev @ A @ ( nil @ A ) )
      = ( nil @ A ) ) ).

% rev.simps(1)
thf(fact_213_rev__swap,axiom,
    ! [A: $tType,Xs: list @ A,Ys2: list @ A] :
      ( ( ( rev @ A @ Xs )
        = Ys2 )
      = ( Xs
        = ( rev @ A @ Ys2 ) ) ) ).

% rev_swap
thf(fact_214_rev_Osimps_I2_J,axiom,
    ! [A: $tType,X3: A,Xs: list @ A] :
      ( ( rev @ A @ ( cons @ A @ X3 @ Xs ) )
      = ( append @ A @ ( rev @ A @ Xs ) @ ( cons @ A @ X3 @ ( nil @ A ) ) ) ) ).

% rev.simps(2)
thf(fact_215_map__tailrec__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( map_tailrec @ A @ B )
      = ( ^ [F4: A > B,As3: list @ A] : ( rev @ B @ ( map_tailrec_rev @ A @ B @ F4 @ As3 @ ( nil @ B ) ) ) ) ) ).

% map_tailrec_def
thf(fact_216_hd__rev,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ( hd @ A @ ( rev @ A @ Xs ) )
        = ( last @ A @ Xs ) ) ) ).

% hd_rev
thf(fact_217_hd__append2,axiom,
    ! [A: $tType,Xs: list @ A,Ys2: list @ A] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ( hd @ A @ ( append @ A @ Xs @ Ys2 ) )
        = ( hd @ A @ Xs ) ) ) ).

% hd_append2
thf(fact_218_hd__concat,axiom,
    ! [A: $tType,Xs: list @ ( list @ A )] :
      ( ( Xs
       != ( nil @ ( list @ A ) ) )
     => ( ( ( hd @ ( list @ A ) @ Xs )
         != ( nil @ A ) )
       => ( ( hd @ A @ ( concat @ A @ Xs ) )
          = ( hd @ A @ ( hd @ ( list @ A ) @ Xs ) ) ) ) ) ).

% hd_concat
thf(fact_219_list_Osel_I1_J,axiom,
    ! [A: $tType,X21: A,X22: list @ A] :
      ( ( hd @ A @ ( cons @ A @ X21 @ X22 ) )
      = X21 ) ).

% list.sel(1)
thf(fact_220_longest__common__prefix,axiom,
    ! [A: $tType,Xs: list @ A,Ys2: list @ A] :
    ? [Ps: list @ A,Xs4: list @ A,Ys4: list @ A] :
      ( ( Xs
        = ( append @ A @ Ps @ Xs4 ) )
      & ( Ys2
        = ( append @ A @ Ps @ Ys4 ) )
      & ( ( Xs4
          = ( nil @ A ) )
        | ( Ys4
          = ( nil @ A ) )
        | ( ( hd @ A @ Xs4 )
         != ( hd @ A @ Ys4 ) ) ) ) ).

% longest_common_prefix
thf(fact_221_hd__append,axiom,
    ! [A: $tType,Xs: list @ A,Ys2: list @ A] :
      ( ( ( Xs
          = ( nil @ A ) )
       => ( ( hd @ A @ ( append @ A @ Xs @ Ys2 ) )
          = ( hd @ A @ Ys2 ) ) )
      & ( ( Xs
         != ( nil @ A ) )
       => ( ( hd @ A @ ( append @ A @ Xs @ Ys2 ) )
          = ( hd @ A @ Xs ) ) ) ) ).

% hd_append
thf(fact_222_last__rev,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ( last @ A @ ( rev @ A @ Xs ) )
        = ( hd @ A @ Xs ) ) ) ).

% last_rev
thf(fact_223_rotate1__hd__tl,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ( rotate1 @ A @ Xs )
        = ( append @ A @ ( tl @ A @ Xs ) @ ( cons @ A @ ( hd @ A @ Xs ) @ ( nil @ A ) ) ) ) ) ).

% rotate1_hd_tl
thf(fact_224_distinct__adj__append__iff,axiom,
    ! [A: $tType,Xs: list @ A,Ys2: list @ A] :
      ( ( distinct_adj @ A @ ( append @ A @ Xs @ Ys2 ) )
      = ( ( distinct_adj @ A @ Xs )
        & ( distinct_adj @ A @ Ys2 )
        & ( ( Xs
            = ( nil @ A ) )
          | ( Ys2
            = ( nil @ A ) )
          | ( ( last @ A @ Xs )
           != ( hd @ A @ Ys2 ) ) ) ) ) ).

% distinct_adj_append_iff
thf(fact_225_distinct__adj__Cons__Cons,axiom,
    ! [B: $tType,X3: B,Y: B,Xs: list @ B] :
      ( ( distinct_adj @ B @ ( cons @ B @ X3 @ ( cons @ B @ Y @ Xs ) ) )
      = ( ( X3 != Y )
        & ( distinct_adj @ B @ ( cons @ B @ Y @ Xs ) ) ) ) ).

% distinct_adj_Cons_Cons
thf(fact_226_distinct__adj__rev,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( distinct_adj @ A @ ( rev @ A @ Xs ) )
      = ( distinct_adj @ A @ Xs ) ) ).

% distinct_adj_rev
thf(fact_227_tl__append2,axiom,
    ! [A: $tType,Xs: list @ A,Ys2: list @ A] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ( tl @ A @ ( append @ A @ Xs @ Ys2 ) )
        = ( append @ A @ ( tl @ A @ Xs ) @ Ys2 ) ) ) ).

% tl_append2
thf(fact_228_butlast__rev,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( butlast @ A @ ( rev @ A @ Xs ) )
      = ( rev @ A @ ( tl @ A @ Xs ) ) ) ).

% butlast_rev
thf(fact_229_list_Ocollapse,axiom,
    ! [A: $tType,List: list @ A] :
      ( ( List
       != ( nil @ A ) )
     => ( ( cons @ A @ ( hd @ A @ List ) @ ( tl @ A @ List ) )
        = List ) ) ).

% list.collapse
thf(fact_230_hd__Cons__tl,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ( cons @ A @ ( hd @ A @ Xs ) @ ( tl @ A @ Xs ) )
        = Xs ) ) ).

% hd_Cons_tl
thf(fact_231_list_Oexpand,axiom,
    ! [A: $tType,List: list @ A,List2: list @ A] :
      ( ( ( List
          = ( nil @ A ) )
        = ( List2
          = ( nil @ A ) ) )
     => ( ( ( List
           != ( nil @ A ) )
         => ( ( List2
             != ( nil @ A ) )
           => ( ( ( hd @ A @ List )
                = ( hd @ A @ List2 ) )
              & ( ( tl @ A @ List )
                = ( tl @ A @ List2 ) ) ) ) )
       => ( List = List2 ) ) ) ).

% list.expand
thf(fact_232_distinct__adj__singleton,axiom,
    ! [B: $tType,X3: B] : ( distinct_adj @ B @ ( cons @ B @ X3 @ ( nil @ B ) ) ) ).

% distinct_adj_singleton
thf(fact_233_tl__Nil,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( ( tl @ A @ Xs )
        = ( nil @ A ) )
      = ( ( Xs
          = ( nil @ A ) )
        | ? [X4: A] :
            ( Xs
            = ( cons @ A @ X4 @ ( nil @ A ) ) ) ) ) ).

% tl_Nil
thf(fact_234_Nil__tl,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( ( nil @ A )
        = ( tl @ A @ Xs ) )
      = ( ( Xs
          = ( nil @ A ) )
        | ? [X4: A] :
            ( Xs
            = ( cons @ A @ X4 @ ( nil @ A ) ) ) ) ) ).

% Nil_tl
thf(fact_235_distinct__adj__ConsD,axiom,
    ! [A: $tType,X3: A,Xs: list @ A] :
      ( ( distinct_adj @ A @ ( cons @ A @ X3 @ Xs ) )
     => ( distinct_adj @ A @ Xs ) ) ).

% distinct_adj_ConsD
thf(fact_236_distinct__adj__Nil,axiom,
    ! [A: $tType] : ( distinct_adj @ A @ ( nil @ A ) ) ).

% distinct_adj_Nil
thf(fact_237_list_Osel_I3_J,axiom,
    ! [A: $tType,X21: A,X22: list @ A] :
      ( ( tl @ A @ ( cons @ A @ X21 @ X22 ) )
      = X22 ) ).

% list.sel(3)
thf(fact_238_list_Osel_I2_J,axiom,
    ! [A: $tType] :
      ( ( tl @ A @ ( nil @ A ) )
      = ( nil @ A ) ) ).

% list.sel(2)
thf(fact_239_distinct__adj__appendD1,axiom,
    ! [A: $tType,Xs: list @ A,Ys2: list @ A] :
      ( ( distinct_adj @ A @ ( append @ A @ Xs @ Ys2 ) )
     => ( distinct_adj @ A @ Xs ) ) ).

% distinct_adj_appendD1
thf(fact_240_distinct__adj__appendD2,axiom,
    ! [A: $tType,Xs: list @ A,Ys2: list @ A] :
      ( ( distinct_adj @ A @ ( append @ A @ Xs @ Ys2 ) )
     => ( distinct_adj @ A @ Ys2 ) ) ).

% distinct_adj_appendD2
thf(fact_241_butlast__tl,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( butlast @ A @ ( tl @ A @ Xs ) )
      = ( tl @ A @ ( butlast @ A @ Xs ) ) ) ).

% butlast_tl
thf(fact_242_last__tl,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( ( Xs
          = ( nil @ A ) )
        | ( ( tl @ A @ Xs )
         != ( nil @ A ) ) )
     => ( ( last @ A @ ( tl @ A @ Xs ) )
        = ( last @ A @ Xs ) ) ) ).

% last_tl
thf(fact_243_list_Oexhaust__sel,axiom,
    ! [A: $tType,List: list @ A] :
      ( ( List
       != ( nil @ A ) )
     => ( List
        = ( cons @ A @ ( hd @ A @ List ) @ ( tl @ A @ List ) ) ) ) ).

% list.exhaust_sel
thf(fact_244_distinct__adj__Cons,axiom,
    ! [A: $tType,X3: A,Xs: list @ A] :
      ( ( distinct_adj @ A @ ( cons @ A @ X3 @ Xs ) )
      = ( ( Xs
          = ( nil @ A ) )
        | ( ( X3
           != ( hd @ A @ Xs ) )
          & ( distinct_adj @ A @ Xs ) ) ) ) ).

% distinct_adj_Cons
thf(fact_245_list_Osplit__sel,axiom,
    ! [B: $tType,A: $tType,P: B > $o,F1: B,F2: A > ( list @ A ) > B,List: list @ A] :
      ( ( P @ ( case_list @ B @ A @ F1 @ F2 @ List ) )
      = ( ( ( List
            = ( nil @ A ) )
         => ( P @ F1 ) )
        & ( ( List
            = ( cons @ A @ ( hd @ A @ List ) @ ( tl @ A @ List ) ) )
         => ( P @ ( F2 @ ( hd @ A @ List ) @ ( tl @ A @ List ) ) ) ) ) ) ).

% list.split_sel
thf(fact_246_list_Osplit__sel__asm,axiom,
    ! [B: $tType,A: $tType,P: B > $o,F1: B,F2: A > ( list @ A ) > B,List: list @ A] :
      ( ( P @ ( case_list @ B @ A @ F1 @ F2 @ List ) )
      = ( ~ ( ( ( List
                = ( nil @ A ) )
              & ~ ( P @ F1 ) )
            | ( ( List
                = ( cons @ A @ ( hd @ A @ List ) @ ( tl @ A @ List ) ) )
              & ~ ( P @ ( F2 @ ( hd @ A @ List ) @ ( tl @ A @ List ) ) ) ) ) ) ) ).

% list.split_sel_asm
thf(fact_247_list_Osimps_I5_J,axiom,
    ! [B: $tType,A: $tType,F1: B,F2: A > ( list @ A ) > B,X21: A,X22: list @ A] :
      ( ( case_list @ B @ A @ F1 @ F2 @ ( cons @ A @ X21 @ X22 ) )
      = ( F2 @ X21 @ X22 ) ) ).

% list.simps(5)
thf(fact_248_list_Osimps_I4_J,axiom,
    ! [A: $tType,B: $tType,F1: B,F2: A > ( list @ A ) > B] :
      ( ( case_list @ B @ A @ F1 @ F2 @ ( nil @ A ) )
      = F1 ) ).

% list.simps(4)
thf(fact_249_list_Ocase__eq__if,axiom,
    ! [A: $tType,B: $tType] :
      ( ( case_list @ B @ A )
      = ( ^ [F12: B,F22: A > ( list @ A ) > B,List3: list @ A] :
            ( if @ B
            @ ( List3
              = ( nil @ A ) )
            @ F12
            @ ( F22 @ ( hd @ A @ List3 ) @ ( tl @ A @ List3 ) ) ) ) ) ).

% list.case_eq_if
thf(fact_250_successively__append__iff,axiom,
    ! [A: $tType,P: A > A > $o,Xs: list @ A,Ys2: list @ A] :
      ( ( successively @ A @ P @ ( append @ A @ Xs @ Ys2 ) )
      = ( ( successively @ A @ P @ Xs )
        & ( successively @ A @ P @ Ys2 )
        & ( ( Xs
            = ( nil @ A ) )
          | ( Ys2
            = ( nil @ A ) )
          | ( P @ ( last @ A @ Xs ) @ ( hd @ A @ Ys2 ) ) ) ) ) ).

% successively_append_iff
thf(fact_251_Cons__in__shuffles__iff,axiom,
    ! [A: $tType,Z: A,Zs2: list @ A,Xs: list @ A,Ys2: list @ A] :
      ( ( member2 @ ( list @ A ) @ ( cons @ A @ Z @ Zs2 ) @ ( shuffles @ A @ Xs @ Ys2 ) )
      = ( ( ( Xs
           != ( nil @ A ) )
          & ( ( hd @ A @ Xs )
            = Z )
          & ( member2 @ ( list @ A ) @ Zs2 @ ( shuffles @ A @ ( tl @ A @ Xs ) @ Ys2 ) ) )
        | ( ( Ys2
           != ( nil @ A ) )
          & ( ( hd @ A @ Ys2 )
            = Z )
          & ( member2 @ ( list @ A ) @ Zs2 @ ( shuffles @ A @ Xs @ ( tl @ A @ Ys2 ) ) ) ) ) ) ).

% Cons_in_shuffles_iff
thf(fact_252_Nil__in__shuffles,axiom,
    ! [A: $tType,Xs: list @ A,Ys2: list @ A] :
      ( ( member2 @ ( list @ A ) @ ( nil @ A ) @ ( shuffles @ A @ Xs @ Ys2 ) )
      = ( ( Xs
          = ( nil @ A ) )
        & ( Ys2
          = ( nil @ A ) ) ) ) ).

% Nil_in_shuffles
thf(fact_253_splice__in__shuffles,axiom,
    ! [A: $tType,Xs: list @ A,Ys2: list @ A] : ( member2 @ ( list @ A ) @ ( splice @ A @ Xs @ Ys2 ) @ ( shuffles @ A @ Xs @ Ys2 ) ) ).

% splice_in_shuffles
thf(fact_254_shufflesE,axiom,
    ! [A: $tType,Zs2: list @ A,Xs: list @ A,Ys2: list @ A] :
      ( ( member2 @ ( list @ A ) @ Zs2 @ ( shuffles @ A @ Xs @ Ys2 ) )
     => ( ( ( Zs2 = Xs )
         => ( Ys2
           != ( nil @ A ) ) )
       => ( ( ( Zs2 = Ys2 )
           => ( Xs
             != ( nil @ A ) ) )
         => ( ! [X: A,Xs4: list @ A] :
                ( ( Xs
                  = ( cons @ A @ X @ Xs4 ) )
               => ! [Z2: A,Zs3: list @ A] :
                    ( ( Zs2
                      = ( cons @ A @ Z2 @ Zs3 ) )
                   => ( ( X = Z2 )
                     => ~ ( member2 @ ( list @ A ) @ Zs3 @ ( shuffles @ A @ Xs4 @ Ys2 ) ) ) ) )
           => ~ ! [Y3: A,Ys4: list @ A] :
                  ( ( Ys2
                    = ( cons @ A @ Y3 @ Ys4 ) )
                 => ! [Z2: A,Zs3: list @ A] :
                      ( ( Zs2
                        = ( cons @ A @ Z2 @ Zs3 ) )
                     => ( ( Y3 = Z2 )
                       => ~ ( member2 @ ( list @ A ) @ Zs3 @ ( shuffles @ A @ Xs @ Ys4 ) ) ) ) ) ) ) ) ) ).

% shufflesE

% Type constructors (7)
thf(tcon_fun___Orderings_Oorder,axiom,
    ! [A6: $tType,A7: $tType] :
      ( ( order @ A7 )
     => ( order @ ( A6 > A7 ) ) ) ).

thf(tcon_fun___Orderings_Oord,axiom,
    ! [A6: $tType,A7: $tType] :
      ( ( ord @ A7 )
     => ( ord @ ( A6 > A7 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Oorder_1,axiom,
    ! [A6: $tType] : ( order @ ( set @ A6 ) ) ).

thf(tcon_Set_Oset___Orderings_Oord_2,axiom,
    ! [A6: $tType] : ( ord @ ( set @ A6 ) ) ).

thf(tcon_HOL_Obool___Orderings_Olinorder,axiom,
    linorder @ $o ).

thf(tcon_HOL_Obool___Orderings_Oorder_3,axiom,
    order @ $o ).

thf(tcon_HOL_Obool___Orderings_Oord_4,axiom,
    ord @ $o ).

% Helper facts (3)
thf(help_If_3_1_T,axiom,
    ! [P: $o] :
      ( ( P = $true )
      | ( P = $false ) ) ).

thf(help_If_2_1_T,axiom,
    ! [A: $tType,X3: A,Y: A] :
      ( ( if @ A @ $false @ X3 @ Y )
      = Y ) ).

thf(help_If_1_1_T,axiom,
    ! [A: $tType,X3: A,Y: A] :
      ( ( if @ A @ $true @ X3 @ Y )
      = X3 ) ).

% Conjectures (1)
thf(conj_0,conjecture,
    knowle1437066798e_know @ a @ ( secrecy_kKS @ m ) ).

%------------------------------------------------------------------------------
